/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioItens;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioLancComissao;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioPedidos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DEVOL_PED_COMERCIO")
public class DevolucaoPedComercio
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private NotaFiscalPropria notaPropriaGerada;
    private GrupoDeBaixa grupoDeBaixa;
    private List<DevolucaoPedComercioPedidos> pedidosDevolvidos = new ArrayList<DevolucaoPedComercioPedidos>();
    private Empresa empresa;
    private List<DevolucaoPedComercioItens> devolucaoItens = new ArrayList<DevolucaoPedComercioItens>();
    private Double valorTotalDevolucoes = 0.0;
    private Double valorBaixaDevolucao = 0.0;
    private Double valorCredito = 0.0;
    private Double valorSaldoTitulosAberto = 0.0;
    private Short gerarTituloBaixaDevolucao = 0;
    private Short gerarLancamentoEstornoComissao = 0;
    private Date dataLancamentoEstornoComissao;
    private GrupoDeBaixa grupoDeBaixaCredito;
    private List<DevolucaoPedComercioLancComissao> lancamentosComissao = new ArrayList<DevolucaoPedComercioLancComissao>();
    private Double valorDesconto = 0.0;

    @Id
    @Column(nullable=false, name="ID_DEVOL_PED_COMERCIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DEVOL_PED_COMERCIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA_GERADA", foreignKey=@ForeignKey(name="FK_DEVOL_PED_COMERCIO_NOTA_PR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NotaFiscalPropria getNotaPropriaGerada() {
        return this.notaPropriaGerada;
    }

    public void setNotaPropriaGerada(NotaFiscalPropria notaPropriaGerada) {
        this.notaPropriaGerada = notaPropriaGerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA", foreignKey=@ForeignKey(name="FK_DEVOL_PED_COM_GR_BAIXA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public GrupoDeBaixa getGrupoDeBaixa() {
        return this.grupoDeBaixa;
    }

    public void setGrupoDeBaixa(GrupoDeBaixa grupoDeBaixa) {
        this.grupoDeBaixa = grupoDeBaixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DEVOL_PED_COMERCIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VR_TOTAL_DEVOLUCAO", precision=15, scale=2)
    public Double getValorTotalDevolucoes() {
        return this.valorTotalDevolucoes;
    }

    public void setValorTotalDevolucoes(Double valorTotalDevolucoes) {
        this.valorTotalDevolucoes = valorTotalDevolucoes;
    }

    @Column(name="VR_BAIXA_DEVOLUCAO", precision=15, scale=2)
    public Double getValorBaixaDevolucao() {
        return this.valorBaixaDevolucao;
    }

    public void setValorBaixaDevolucao(Double valorBaixaDevolucao) {
        this.valorBaixaDevolucao = valorBaixaDevolucao;
    }

    @Column(name="VR_CREDITO", precision=15, scale=2)
    public Double getValorCredito() {
        return this.valorCredito;
    }

    public void setValorCredito(Double valorCredito) {
        this.valorCredito = valorCredito;
    }

    @Column(name="VR_SALDO_TIT_ABERTO", precision=15, scale=2)
    public Double getValorSaldoTitulosAberto() {
        return this.valorSaldoTitulosAberto;
    }

    public void setValorSaldoTitulosAberto(Double valorSaldoTitulosAberto) {
        this.valorSaldoTitulosAberto = valorSaldoTitulosAberto;
    }

    @Column(name="GERAR_TIT_BAIXA_DEVOLUCAO")
    public Short getGerarTituloBaixaDevolucao() {
        return this.gerarTituloBaixaDevolucao;
    }

    public void setGerarTituloBaixaDevolucao(Short gerarTituloBaixaDevolucao) {
        this.gerarTituloBaixaDevolucao = gerarTituloBaixaDevolucao;
    }

    @Column(name="GERAR_LANC_ESTORNO_COMISSAO")
    public Short getGerarLancamentoEstornoComissao() {
        return this.gerarLancamentoEstornoComissao;
    }

    public void setGerarLancamentoEstornoComissao(Short gerarLancamentoEstornoComissao) {
        this.gerarLancamentoEstornoComissao = gerarLancamentoEstornoComissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LANC_ESTORNO_COMISSAO")
    public Date getDataLancamentoEstornoComissao() {
        return this.dataLancamentoEstornoComissao;
    }

    public void setDataLancamentoEstornoComissao(Date dataLancamentoEstornoComissao) {
        this.dataLancamentoEstornoComissao = dataLancamentoEstornoComissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA_CREDITO", foreignKey=@ForeignKey(name="FK_DEVOL_PED_COM_GR_BAIXA_CRED"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public GrupoDeBaixa getGrupoDeBaixaCredito() {
        return this.grupoDeBaixaCredito;
    }

    public void setGrupoDeBaixaCredito(GrupoDeBaixa grupoDeBaixaCredito) {
        this.grupoDeBaixaCredito = grupoDeBaixaCredito;
    }

    @OneToMany(mappedBy="devolucaoPedComercio", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoPedComercioPedidos> getPedidosDevolvidos() {
        return this.pedidosDevolvidos;
    }

    public void setPedidosDevolvidos(List<DevolucaoPedComercioPedidos> pedidosDevolvidos) {
        this.pedidosDevolvidos = pedidosDevolvidos;
    }

    @OneToMany(mappedBy="devolucaoPedComercio", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoPedComercioItens> getDevolucaoItens() {
        return this.devolucaoItens;
    }

    public void setDevolucaoItens(List<DevolucaoPedComercioItens> devolucaoItens) {
        this.devolucaoItens = devolucaoItens;
    }

    @OneToMany(mappedBy="devolucaoPedComercio", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoPedComercioLancComissao> getLancamentosComissao() {
        return this.lancamentosComissao;
    }

    public void setLancamentosComissao(List<DevolucaoPedComercioLancComissao> lancamentosComissao) {
        this.lancamentosComissao = lancamentosComissao;
    }

    @Column(name="VR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }
}

