/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoVendas;
import com.touchcomp.basementor.model.vo.DevolucaoVendasItens;
import com.touchcomp.basementor.model.vo.DevolucaoVendasLancComissao;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFCe;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFPropria;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFTerceiros;
import com.touchcomp.basementor.model.vo.DevolucaoVendasPedido;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DEVOL_VENDAS")
public class DevolucaoVendas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private NotaFiscalPropria notaPropriaGerada;
    private NotaFiscalTerceiros notaTerceirosGerada;
    private GrupoDeBaixa grupoDeBaixa;
    private List<DevolucaoVendasNFPropria> notasPropriaDevolvida;
    private Empresa empresa;
    private List<DevolucaoVendasLancComissao> lancamentosComissao;
    private List<DevolucaoVendasItens> devolucaoItens;
    private Double valorTotalDevolucoes = 0.0;
    private Double valorBaixaDevolucao = 0.0;
    private Double valorCredito = 0.0;
    private Double valorDevolver = 0.0;
    private Double valorSaldoTitulosAberto = 0.0;
    private Titulo tituloDevolver;
    private Date dataVencimentoTituloDevolver;
    private Short gerarTituloBaixaDevolucao = 0;
    private Short gerarLancamentoEstornoComissao = 0;
    private Date dataLancamentoEstornoComissao;
    private GrupoDeBaixa grupoDeBaixaCredito;
    private Short tipoDevolucao = 1;
    private List<DevolucaoVendasNFTerceiros> notasTerceirosDevolvida;
    private Short respeitarAliquotaIcmsDevolucao = 0;
    private Short respeitarAliquotaIpiDevolucao = 0;
    private Short respeitarAliquotaPisCofinsDevolucao = 0;
    private Short devolucaoTroca = 0;
    private Short tipoBaixaDevolucao = 0;
    private Short respeitarPlanoContaClienteFornecedor = 1;
    private PlanoConta planoConta;
    private PlanoConta planoContaAntecipacao;
    private ClassificacaoVendas classificacaoVendas;
    private Short naoGerarLancAdicional = 0;
    private String motivoExclusaoTituloBaixa;
    private Usuario usuarioExclusaoTituloBaixa;
    private List<DevolucaoVendasNFCe> nfces = new ArrayList<DevolucaoVendasNFCe>();
    private List<DevolucaoVendasPedido> pedidos;
    private Short informarPlanosCosta = 0;
    private PlanoConta planoContaDebito;
    private PlanoConta planoContaCredito;
    private Short calcularSTDespAcessorias = 0;
    private Short gerarCupomDesconto = 0;

    public DevolucaoVendas() {
        this.notasPropriaDevolvida = new ArrayList<DevolucaoVendasNFPropria>();
        this.lancamentosComissao = new ArrayList<DevolucaoVendasLancComissao>();
        this.devolucaoItens = new ArrayList<DevolucaoVendasItens>();
        this.notasTerceirosDevolvida = new ArrayList<DevolucaoVendasNFTerceiros>();
        this.pedidos = new ArrayList<DevolucaoVendasPedido>();
    }

    @Id
    @Column(nullable=false, name="ID_DEVOL_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DEVOL_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA_GERADA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_NOTA_PROPRIA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NotaFiscalPropria getNotaPropriaGerada() {
        return this.notaPropriaGerada;
    }

    public void setNotaPropriaGerada(NotaFiscalPropria notaPropriaGerada) {
        this.notaPropriaGerada = notaPropriaGerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_TERC_GERADA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_NOTA_TERC"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NotaFiscalTerceiros getNotaTerceirosGerada() {
        return this.notaTerceirosGerada;
    }

    public void setNotaTerceirosGerada(NotaFiscalTerceiros notaTerceirosGerada) {
        this.notaTerceirosGerada = notaTerceirosGerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_GRUPO_BAIXA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public GrupoDeBaixa getGrupoDeBaixa() {
        return this.grupoDeBaixa;
    }

    public void setGrupoDeBaixa(GrupoDeBaixa grupoDeBaixa) {
        this.grupoDeBaixa = grupoDeBaixa;
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasNFPropria> getNotasPropriaDevolvida() {
        return this.notasPropriaDevolvida;
    }

    public void setNotasPropriaDevolvida(List<DevolucaoVendasNFPropria> notasPropriaDevolvida) {
        this.notasPropriaDevolvida = notasPropriaDevolvida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasLancComissao> getLancamentosComissao() {
        return this.lancamentosComissao;
    }

    public void setLancamentosComissao(List<DevolucaoVendasLancComissao> lancamentosComissao) {
        this.lancamentosComissao = lancamentosComissao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasItens> getDevolucaoItens() {
        return this.devolucaoItens;
    }

    public void setDevolucaoItens(List<DevolucaoVendasItens> devolucaoItens) {
        this.devolucaoItens = devolucaoItens;
    }

    @Column(name="VR_TOTAL_DEVOLUCAO", precision=15, scale=2)
    public Double getValorTotalDevolucoes() {
        return this.valorTotalDevolucoes;
    }

    public void setValorTotalDevolucoes(Double valorTotalDevolucoes) {
        this.valorTotalDevolucoes = valorTotalDevolucoes;
    }

    @Column(name="VR_BAIXA_DEVOLUCAO", precision=15, scale=2)
    public Double getValorBaixaDevolucao() {
        return this.valorBaixaDevolucao;
    }

    public void setValorBaixaDevolucao(Double valorBaixaDevolucao) {
        this.valorBaixaDevolucao = valorBaixaDevolucao;
    }

    @Column(name="VR_CREDITO", precision=15, scale=2)
    public Double getValorCredito() {
        return this.valorCredito;
    }

    public void setValorCredito(Double valorCredito) {
        this.valorCredito = valorCredito;
    }

    @Column(name="VR_DEVOLVER", precision=15, scale=2)
    public Double getValorDevolver() {
        return this.valorDevolver;
    }

    public void setValorDevolver(Double valorDevolver) {
        this.valorDevolver = valorDevolver;
    }

    @Column(name="VR_SALDO_TIT_ABERTO", precision=15, scale=2)
    public Double getValorSaldoTitulosAberto() {
        return this.valorSaldoTitulosAberto;
    }

    public void setValorSaldoTitulosAberto(Double valorSaldoTitulosAberto) {
        this.valorSaldoTitulosAberto = valorSaldoTitulosAberto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO_DEVOLVER", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_TIT_DEVOLVER"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Titulo getTituloDevolver() {
        return this.tituloDevolver;
    }

    public void setTituloDevolver(Titulo tituloDevolver) {
        this.tituloDevolver = tituloDevolver;
    }

    @Column(name="DATA_VENC_TIT_DEVOLVER")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoTituloDevolver() {
        return this.dataVencimentoTituloDevolver;
    }

    public void setDataVencimentoTituloDevolver(Date dataVencimentoTituloDevolver) {
        this.dataVencimentoTituloDevolver = dataVencimentoTituloDevolver;
    }

    @Column(name="GERAR_TIT_BAIXA_DEVOLUCAO")
    public Short getGerarTituloBaixaDevolucao() {
        return this.gerarTituloBaixaDevolucao;
    }

    public void setGerarTituloBaixaDevolucao(Short gerarTituloBaixaDevolucao) {
        this.gerarTituloBaixaDevolucao = gerarTituloBaixaDevolucao;
    }

    @Column(name="GERAR_LANC_ESTORNO_COMISSAO")
    public Short getGerarLancamentoEstornoComissao() {
        return this.gerarLancamentoEstornoComissao;
    }

    public void setGerarLancamentoEstornoComissao(Short gerarLancamentoEstornoComissao) {
        this.gerarLancamentoEstornoComissao = gerarLancamentoEstornoComissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LANC_ESTORNO_COMISSAO")
    public Date getDataLancamentoEstornoComissao() {
        return this.dataLancamentoEstornoComissao;
    }

    public void setDataLancamentoEstornoComissao(Date dataLancamentoEstornoComissao) {
        this.dataLancamentoEstornoComissao = dataLancamentoEstornoComissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA_CREDITO", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_GR_BAIXA_CREDIT"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public GrupoDeBaixa getGrupoDeBaixaCredito() {
        return this.grupoDeBaixaCredito;
    }

    public void setGrupoDeBaixaCredito(GrupoDeBaixa grupoDeBaixaCredito) {
        this.grupoDeBaixaCredito = grupoDeBaixaCredito;
    }

    @Column(name="TIPO_DEVOLUCAO")
    public Short getTipoDevolucao() {
        return this.tipoDevolucao;
    }

    public void setTipoDevolucao(Short tipoDevolucao) {
        this.tipoDevolucao = tipoDevolucao;
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasNFTerceiros> getNotasTerceirosDevolvida() {
        return this.notasTerceirosDevolvida;
    }

    public void setNotasTerceirosDevolvida(List<DevolucaoVendasNFTerceiros> notasTerceirosDevolvida) {
        this.notasTerceirosDevolvida = notasTerceirosDevolvida;
    }

    @Column(name="RESPEITAR_ALIQ_ICMS_DEVOL")
    public Short getRespeitarAliquotaIcmsDevolucao() {
        return this.respeitarAliquotaIcmsDevolucao;
    }

    public void setRespeitarAliquotaIcmsDevolucao(Short respeitarAliquotaIcmsDevolucao) {
        this.respeitarAliquotaIcmsDevolucao = respeitarAliquotaIcmsDevolucao;
    }

    @Column(name="RESPEITAR_ALIQ_IPI_DEVOL")
    public Short getRespeitarAliquotaIpiDevolucao() {
        return this.respeitarAliquotaIpiDevolucao;
    }

    public void setRespeitarAliquotaIpiDevolucao(Short respeitarAliquotaIpiDevolucao) {
        this.respeitarAliquotaIpiDevolucao = respeitarAliquotaIpiDevolucao;
    }

    @Column(name="RESPEITAR_ALIQ_PIS_COFINS_DEVOL")
    public Short getRespeitarAliquotaPisCofinsDevolucao() {
        return this.respeitarAliquotaPisCofinsDevolucao;
    }

    public void setRespeitarAliquotaPisCofinsDevolucao(Short respeitarAliquotaPisCofinsDevolucao) {
        this.respeitarAliquotaPisCofinsDevolucao = respeitarAliquotaPisCofinsDevolucao;
    }

    @Column(name="DEVOLUCAO_TROCA")
    public Short getDevolucaoTroca() {
        return this.devolucaoTroca;
    }

    public void setDevolucaoTroca(Short devolucaoTroca) {
        this.devolucaoTroca = devolucaoTroca;
    }

    @Column(name="TIPO_BAIXA_DEVOLUCAO")
    public Short getTipoBaixaDevolucao() {
        return this.tipoBaixaDevolucao;
    }

    public void setTipoBaixaDevolucao(Short tipoBaixaDevolucao) {
        this.tipoBaixaDevolucao = tipoBaixaDevolucao;
    }

    @Column(name="RESPEITAR_PLANO_CONTA_CLI_FORN")
    public Short getRespeitarPlanoContaClienteFornecedor() {
        return this.respeitarPlanoContaClienteFornecedor;
    }

    public void setRespeitarPlanoContaClienteFornecedor(Short respeitarPlanoContaClienteFornecedor) {
        this.respeitarPlanoContaClienteFornecedor = respeitarPlanoContaClienteFornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_ANTECIPACAO", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_PLANO_CONTA_ANT"))
    public PlanoConta getPlanoContaAntecipacao() {
        return this.planoContaAntecipacao;
    }

    public void setPlanoContaAntecipacao(PlanoConta planoContaAntecipacao) {
        this.planoContaAntecipacao = planoContaAntecipacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_VENDAS", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_CLASSIF_VENDAS"))
    public ClassificacaoVendas getClassificacaoVendas() {
        return this.classificacaoVendas;
    }

    public void setClassificacaoVendas(ClassificacaoVendas classificacaoVendas) {
        this.classificacaoVendas = classificacaoVendas;
    }

    @Column(name="NAO_GERAR_LANC_ADICIONAL")
    public Short getNaoGerarLancAdicional() {
        return this.naoGerarLancAdicional;
    }

    public void setNaoGerarLancAdicional(Short naoGerarLancAdicional) {
        this.naoGerarLancAdicional = naoGerarLancAdicional;
    }

    @Column(name="MOTIVO_EXCLUSAO_TITULO_BAIXA", length=500)
    public String getMotivoExclusaoTituloBaixa() {
        return this.motivoExclusaoTituloBaixa;
    }

    public void setMotivoExclusaoTituloBaixa(String motivoExclusaoTituloBaixa) {
        this.motivoExclusaoTituloBaixa = motivoExclusaoTituloBaixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_EXCLUSAO_TIT_BAIXA", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_USU_EXC_BAIXA"))
    public Usuario getUsuarioExclusaoTituloBaixa() {
        return this.usuarioExclusaoTituloBaixa;
    }

    public void setUsuarioExclusaoTituloBaixa(Usuario usuarioExclusaoTituloBaixa) {
        this.usuarioExclusaoTituloBaixa = usuarioExclusaoTituloBaixa;
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasNFCe> getNfces() {
        return this.nfces;
    }

    public void setNfces(List<DevolucaoVendasNFCe> nfces) {
        this.nfces = nfces;
    }

    @OneToMany(mappedBy="devolucaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DevolucaoVendasPedido> getPedidos() {
        return this.pedidos;
    }

    public void setPedidos(List<DevolucaoVendasPedido> pedidos) {
        this.pedidos = pedidos;
    }

    @Column(name="INFORMAR_PLANOS_CONTA")
    public Short getInformarPlanosCosta() {
        return this.informarPlanosCosta;
    }

    public void setInformarPlanosCosta(Short informarPlanosCosta) {
        this.informarPlanosCosta = informarPlanosCosta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_PLANO_CONTA_DEB"))
    public PlanoConta getPlanoContaDebito() {
        return this.planoContaDebito;
    }

    public void setPlanoContaDebito(PlanoConta planoContaDebito) {
        this.planoContaDebito = planoContaDebito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_DEVOL_VENDAS_PLANO_CONTA_CRE"))
    public PlanoConta getPlanoContaCredito() {
        return this.planoContaCredito;
    }

    public void setPlanoContaCredito(PlanoConta planoContaCredito) {
        this.planoContaCredito = planoContaCredito;
    }

    @Column(name="calcular_st_desp_acess")
    public Short getCalcularSTDespAcessorias() {
        return this.calcularSTDespAcessorias;
    }

    public void setCalcularSTDespAcessorias(Short calcularSTDespAcessorias) {
        this.calcularSTDespAcessorias = calcularSTDespAcessorias;
    }

    @Column(name="gerar_cupom_desconto")
    public Short getGerarCupomDesconto() {
        return this.gerarCupomDesconto;
    }

    public void setGerarCupomDesconto(Short gerarCupomDesconto) {
        this.gerarCupomDesconto = gerarCupomDesconto;
    }
}

