/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ItemIntegPtEletronico;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="DIA_HORA_TRABALHO")
public class DiaHoraTrabalho
implements InterfaceVO {
    private Long identificador;
    private Date dataArquivo;
    private Double horaInicial;
    private Double horaFinal;
    private ItemIntegPtEletronico itemInteg;
    private Integer indice;
    private Integer diaSemana;
    private Double faltas;
    private Double extras;
    private Double creditos;

    public DiaHoraTrabalho() {
        this.horaInicial = 0.0;
        this.horaFinal = 0.0;
        this.faltas = 0.0;
        this.extras = 0.0;
        this.creditos = 0.0;
        this.indice = 0;
        this.diaSemana = 0;
    }

    public DiaHoraTrabalho(Date dataArquivo) {
        this.dataArquivo = dataArquivo;
        this.horaInicial = 0.0;
        this.horaFinal = 0.0;
        this.faltas = 0.0;
        this.extras = 0.0;
        this.creditos = 0.0;
    }

    public DiaHoraTrabalho(Date dataArquivo, Double faltas) {
        this.dataArquivo = dataArquivo;
        this.horaInicial = 0.0;
        this.horaFinal = 0.0;
        this.faltas = faltas;
        this.extras = 0.0;
        this.creditos = 0.0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_DIA_HORA_TRABALHO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DIA_HORA_TRABALHO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ARQUIVO")
    public Date getDataArquivo() {
        return this.dataArquivo;
    }

    public void setDataArquivo(Date dataArquivo) {
        this.dataArquivo = dataArquivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_INTEG", foreignKey=@ForeignKey(name="FK_DIA_HORA_TRABALHO_IT_INTEG"))
    public ItemIntegPtEletronico getItemInteg() {
        return this.itemInteg;
    }

    public void setItemInteg(ItemIntegPtEletronico itemInteg) {
        this.itemInteg = itemInteg;
    }

    @Column(name="INDICE")
    public Integer getIndice() {
        return this.indice;
    }

    public void setIndice(Integer indice) {
        this.indice = indice;
    }

    @Column(nullable=false, name="HORA_FINAL", precision=15, scale=2)
    public Double getHoraFinal() {
        return this.horaFinal;
    }

    public void setHoraFinal(Double horaFinal) {
        this.horaFinal = horaFinal;
    }

    @Column(name="HORA_INICIAL", precision=15, scale=2)
    public Double getHoraInicial() {
        return this.horaInicial;
    }

    public void setHoraInicial(Double horaInicial) {
        this.horaInicial = horaInicial;
    }

    @Column(name="DIA_SEMANA")
    public Integer getDiaSemana() {
        return this.diaSemana;
    }

    public void setDiaSemana(Integer diaSemana) {
        this.diaSemana = diaSemana;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getHoraInicial(), this.getHoraFinal()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="FALTAS", precision=15, scale=2)
    public Double getFaltas() {
        return this.faltas;
    }

    public void setFaltas(Double faltas) {
        this.faltas = faltas;
    }

    @Column(nullable=false, name="EXTRAS", precision=15, scale=2)
    public Double getExtras() {
        return this.extras;
    }

    public void setExtras(Double extras) {
        this.extras = extras;
    }

    @Column(nullable=false, name="CREDITOS", precision=15, scale=2)
    public Double getCreditos() {
        return this.creditos;
    }

    public void setCreditos(Double creditos) {
        this.creditos = creditos;
    }
}

