/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CfopBonificacaoDistSobraCoop;
import com.touchcomp.basementor.model.vo.CfopFatEntradaDistSobraCoop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoCooperado;
import com.touchcomp.basementor.model.vo.ItemDistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.LancContAdicDocFinanceiro;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DISTRIB_SOBRA_COOPERADO")
public class DistribuicaoSobraCooperado
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataInicial;
    private Date dataFinal;
    private Double valorDistribuicao = 0.0;
    private Double valorVenda = 0.0;
    private Double valorDevolucao = 0.0;
    private Double valorTotal = 0.0;
    private List<ItemDistribuicaoSobraCooperado> itensDistribuicaoSobraCooperado = new ArrayList<ItemDistribuicaoSobraCooperado>();
    private String observacao;
    private CarteiraCobranca carteiraCobranca;
    private CentroCusto centroCusto;
    private PlanoConta planoConta;
    private PlanoContaGerencial planoContaGerencial;
    private Date dataEmissao;
    private Date dataCompetencia;
    private Date dataVencimento;
    private Date dataLimiteDesconto;
    private Date dataEvento;
    private TipoDoc tipoDoc;
    private LancContAdicDocFinanceiro lancContAdicDocFinanc;
    private String obsTitulo;
    private EventoCooperado eventoCooperado;
    private List<CfopBonificacaoDistSobraCoop> cfopsBonificacao = new ArrayList<CfopBonificacaoDistSobraCoop>();
    private Short descontarIrrf = 0;
    private Titulo tituloIrrf;
    private Short filtrarGrupoEmpresa = 0;
    private List<CfopFatEntradaDistSobraCoop> cfopsFatEntrada = new ArrayList<CfopFatEntradaDistSobraCoop>();
    private Double valorFatEntrada = 0.0;
    private Double valorBonificacao = 0.0;
    private Double valorPrestacaoServicos = 0.0;
    private Short tipoGeracao = EnumConstantsMentorSimNao.NAO.getValue();
    private EventoCooperado eventoCooperadoEvento;

    @Id
    @Column(nullable=false, name="ID_DISTRIB_SOBRA_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DISTRIB_SOBRA_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DIST_SOBRA_COOPERADO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(nullable=false, name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(nullable=false, name="VALOR_DISTRIBUICAO", precision=15, scale=2)
    public Double getValorDistribuicao() {
        return this.valorDistribuicao;
    }

    public void setValorDistribuicao(Double valorDistribuicao) {
        this.valorDistribuicao = valorDistribuicao;
    }

    @Column(nullable=false, name="VALOR_VENDA", precision=15, scale=2)
    public Double getValorVenda() {
        return this.valorVenda;
    }

    public void setValorVenda(Double valorVenda) {
        this.valorVenda = valorVenda;
    }

    @Column(nullable=false, name="VALOR_DEVOLUCAO", precision=15, scale=2)
    public Double getValorDevolucao() {
        return this.valorDevolucao;
    }

    public void setValorDevolucao(Double valorDevolucao) {
        this.valorDevolucao = valorDevolucao;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @OneToMany(mappedBy="distribuicaoSobraCooperado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemDistribuicaoSobraCooperado> getItensDistribuicaoSobraCooperado() {
        return this.itensDistribuicaoSobraCooperado;
    }

    public void setItensDistribuicaoSobraCooperado(List<ItemDistribuicaoSobraCooperado> itensDistribuicaoSobraCooperado) {
        this.itensDistribuicaoSobraCooperado = itensDistribuicaoSobraCooperado;
    }

    @Column(nullable=true, name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_CART_COB"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_CEN_CUST"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_PL_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_PL_GERENC"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPETENCIA")
    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIMITE_DESCONTO")
    public Date getDataLimiteDesconto() {
        return this.dataLimiteDesconto;
    }

    public void setDataLimiteDesconto(Date dataLimiteDesconto) {
        this.dataLimiteDesconto = dataLimiteDesconto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EVENTO")
    public Date getDataEvento() {
        return this.dataEvento;
    }

    public void setDataEvento(Date dataEvento) {
        this.dataEvento = dataEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_TIPO_DOC"))
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANC_CONT_ADIC_DOC_FINANC", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_LANC_ADIC"))
    public LancContAdicDocFinanceiro getLancContAdicDocFinanc() {
        return this.lancContAdicDocFinanc;
    }

    public void setLancContAdicDocFinanc(LancContAdicDocFinanceiro lancContAdicDocFinanc) {
        this.lancContAdicDocFinanc = lancContAdicDocFinanc;
    }

    @Column(name="OBS_TITULO", length=500)
    public String getObsTitulo() {
        return this.obsTitulo;
    }

    public void setObsTitulo(String obsTitulo) {
        this.obsTitulo = obsTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_COOPERADO", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOP_EVT_COOP"))
    public EventoCooperado getEventoCooperado() {
        return this.eventoCooperado;
    }

    public void setEventoCooperado(EventoCooperado eventoCooperado) {
        this.eventoCooperado = eventoCooperado;
    }

    @OneToMany(mappedBy="distribuicaoSobraCoop", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CfopBonificacaoDistSobraCoop> getCfopsBonificacao() {
        return this.cfopsBonificacao;
    }

    public void setCfopsBonificacao(List<CfopBonificacaoDistSobraCoop> cfopsBonificacao) {
        this.cfopsBonificacao = cfopsBonificacao;
    }

    @Column(name="DESCONTAR_IRRF")
    public Short getDescontarIrrf() {
        return this.descontarIrrf;
    }

    public void setDescontarIrrf(Short descontarIrrf) {
        this.descontarIrrf = descontarIrrf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_titulo_irrf")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Titulo getTituloIrrf() {
        return this.tituloIrrf;
    }

    public void setTituloIrrf(Titulo tituloIrrf) {
        this.tituloIrrf = tituloIrrf;
    }

    @Column(name="filtrar_grupo_empresa")
    public Short getFiltrarGrupoEmpresa() {
        return this.filtrarGrupoEmpresa;
    }

    public void setFiltrarGrupoEmpresa(Short filtrarGrupoEmpresa) {
        this.filtrarGrupoEmpresa = filtrarGrupoEmpresa;
    }

    @OneToMany(mappedBy="distribuicaoSobraCoop", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CfopFatEntradaDistSobraCoop> getCfopsFatEntrada() {
        return this.cfopsFatEntrada;
    }

    public void setCfopsFatEntrada(List<CfopFatEntradaDistSobraCoop> cfopsFatEntrada) {
        this.cfopsFatEntrada = cfopsFatEntrada;
    }

    @Column(name="VALOR_FAT_ENTRADA", precision=15, scale=2)
    public Double getValorFatEntrada() {
        return this.valorFatEntrada;
    }

    public void setValorFatEntrada(Double valorFatEntrada) {
        this.valorFatEntrada = valorFatEntrada;
    }

    @Column(name="VALOR_BONIFICACAO", precision=15, scale=2)
    public Double getValorBonificacao() {
        return this.valorBonificacao;
    }

    public void setValorBonificacao(Double valorBonificacao) {
        this.valorBonificacao = valorBonificacao;
    }

    @Column(name="VALOR_PRESTACAO_SERVICOS", precision=15, scale=2)
    public Double getValorPrestacaoServicos() {
        return this.valorPrestacaoServicos;
    }

    public void setValorPrestacaoServicos(Double valorPrestacaoServicos) {
        this.valorPrestacaoServicos = valorPrestacaoServicos;
    }

    @Column(name="TIPO_GERACAO")
    public Short getTipoGeracao() {
        return this.tipoGeracao;
    }

    public void setTipoGeracao(Short tipoGeracao) {
        this.tipoGeracao = tipoGeracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_COOPERADO_EVENTO", foreignKey=@ForeignKey(name="FK_DISTRIB_SOBRA_COOPERADO_ECE"))
    public EventoCooperado getEventoCooperadoEvento() {
        return this.eventoCooperadoEvento;
    }

    public void setEventoCooperadoEvento(EventoCooperado eventoCooperadoEvento) {
        this.eventoCooperadoEvento = eventoCooperadoEvento;
    }
}

