/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemDuplicataTransporte;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

@Entity
@Table(name="DUPLICATA_TRANSPORTE")
public class DuplicataTransporte
implements InterfaceVO {
    private Long identificador;
    private String nrDuplicata;
    private Double valorTotDupInf = 0.0;
    private Double valorDescIcmsSt = 0.0;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private List<ItemDuplicataTransporte> itemDupTransporte = new ArrayList<ItemDuplicataTransporte>();
    private Titulo titulo;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double descFinanceiroTitulo = 0.0;
    private PlanoContaGerencial planoContaGerencial;
    private CentroCusto centroCusto;

    @Id
    @Column(nullable=false, name="ID_DUPLICATA_TRANSPORTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DUPLICATA_TRANSPORTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="NR_DUPLICATA", length=30)
    public String getNrDuplicata() {
        return this.nrDuplicata;
    }

    public void setNrDuplicata(String nrDuplicata) {
        this.nrDuplicata = nrDuplicata;
    }

    @Column(name="VALOR_TOT_DUP_INF", precision=15, scale=2)
    public Double getValorTotDupInf() {
        return this.valorTotDupInf;
    }

    public void setValorTotDupInf(Double valorTotDupInf) {
        this.valorTotDupInf = valorTotDupInf;
    }

    @Column(name="VALOR_DESC_ICMSST", precision=15, scale=2)
    public Double getValorDescIcmsSt() {
        return this.valorDescIcmsSt;
    }

    public void setValorDescIcmsSt(Double valorDescIcmsSt) {
        this.valorDescIcmsSt = valorDescIcmsSt;
    }

    @Transient
    @OneToMany(mappedBy="duplicataTransporte")
    public List<ItemDuplicataTransporte> getItemDupTransporte() {
        return this.itemDupTransporte;
    }

    public void setItemDupTransporte(List<ItemDuplicataTransporte> itemDupTransporte) {
        this.itemDupTransporte = itemDupTransporte;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_DUPLICATA_TRANSPORTE_TITULO"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @JoinColumn(name="ID_UNIDADE_FAT_FORN", foreignKey=@ForeignKey(name="FK_DUPLICATA_TRANSPORTE_UN_FAT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DUPLICATA_TRANSPORTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="VOLOR_DESC_FINAN_TIT", precision=12, scale=2)
    public Double getDescFinanceiroTitulo() {
        return this.descFinanceiroTitulo;
    }

    public void setDescFinanceiroTitulo(Double descFinanceiroTitulo) {
        this.descFinanceiroTitulo = descFinanceiroTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_DUPLICATA_TRANSPORTE_PC_GER"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_DUPLICATA_TRANSPORTE_CEN_CUS"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

