/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="EMBALAGEM", uniqueConstraints={@UniqueConstraint(name="UNQ1_EMBALAGEM_NOME", columnNames={"NOME"})})
public class Embalagem
implements InterfaceVO {
    @Id
    @Column(nullable=false, unique=true, name="ID_EMBALAGEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMBALAGEM")
    private Long identificador;
    @Column(nullable=false, unique=true, name="NOME", length=50)
    private String nome;
    @Column(nullable=false, name="PESO", precision=12, scale=3)
    private Double peso = 0.0;
    @Column(nullable=false, name="VOLUME", precision=12, scale=2)
    private Double volume = 0.0;
    @Column(nullable=false, name="CAPACIDADE_PESO", precision=12, scale=3)
    private Double capacidadePeso = 0.0;
    @Column(nullable=false, name="CAPACIDADE_VOLUME", precision=12, scale=3)
    private Double capacidadeVolume = 0.0;
    @Column(nullable=false, name="ALTURA", precision=12, scale=3)
    private Double altura = 0.0;
    @Column(nullable=false, name="LARGURA", precision=12, scale=3)
    private Double largura = 0.0;
    @Column(nullable=false, name="COMPRIMENTO", precision=12, scale=3)
    private Double comprimento = 0.0;
    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EMPRESA"))
    private Empresa empresa;
    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro;
    @Column(name="ATIVO", nullable=false, unique=false)
    private Short ativo = 1;

    public Embalagem(Long id, Double p, String n, Double v) {
        this();
        this.identificador = id;
        this.peso = p;
        this.volume = v;
        this.nome = n;
        this.ativo = 1;
    }

    public Embalagem() {
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @lombok.Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @lombok.Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @lombok.Generated
    public void setPeso(Double peso) {
        this.peso = peso;
    }

    @lombok.Generated
    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @lombok.Generated
    public void setCapacidadePeso(Double capacidadePeso) {
        this.capacidadePeso = capacidadePeso;
    }

    @lombok.Generated
    public void setCapacidadeVolume(Double capacidadeVolume) {
        this.capacidadeVolume = capacidadeVolume;
    }

    @lombok.Generated
    public void setAltura(Double altura) {
        this.altura = altura;
    }

    @lombok.Generated
    public void setLargura(Double largura) {
        this.largura = largura;
    }

    @lombok.Generated
    public void setComprimento(Double comprimento) {
        this.comprimento = comprimento;
    }

    @lombok.Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @lombok.Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @lombok.Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @lombok.Generated
    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @lombok.Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @lombok.Generated
    public String getNome() {
        return this.nome;
    }

    @lombok.Generated
    public Double getPeso() {
        return this.peso;
    }

    @lombok.Generated
    public Double getVolume() {
        return this.volume;
    }

    @lombok.Generated
    public Double getCapacidadePeso() {
        return this.capacidadePeso;
    }

    @lombok.Generated
    public Double getCapacidadeVolume() {
        return this.capacidadeVolume;
    }

    @lombok.Generated
    public Double getAltura() {
        return this.altura;
    }

    @lombok.Generated
    public Double getLargura() {
        return this.largura;
    }

    @lombok.Generated
    public Double getComprimento() {
        return this.comprimento;
    }

    @lombok.Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @lombok.Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @lombok.Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @lombok.Generated
    public Short getAtivo() {
        return this.ativo;
    }
}

