/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocMtvCancAvPrevio;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTipoAvisoPrevio;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="EMISSAO_AVISO_TRABALHADO")
public class EmissaoAvisoTrabalhado
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Colaborador colaborador;
    private Date dataEmissaoAviso;
    private Date inicioAviso;
    private Date finalAviso;
    private Date dataPagamento;
    private Date dataAfastamento;
    private EsocTipoAvisoPrevio tipoAviso;
    private Date dataCancelamento;
    private EsocMtvCancAvPrevio motivoCancelamentoAviso;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short cancelarAviso = 0;
    private Integer diasReducao = 0;
    private Double diasAviso = 0.0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();

    @Id
    @Column(nullable=false, unique=true, name="ID_EMISSAO_AVISO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMISSAO_AVISO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_EMISSAO_AVISO_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="DATA_EMISSAO_AVISO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoAviso() {
        return this.dataEmissaoAviso;
    }

    public void setDataEmissaoAviso(Date dataEmissaoAviso) {
        this.dataEmissaoAviso = dataEmissaoAviso;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="INICIO_AVISO")
    public Date getInicioAviso() {
        return this.inicioAviso;
    }

    public void setInicioAviso(Date inicioAviso) {
        this.inicioAviso = inicioAviso;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="FINAL_AVISO")
    public Date getFinalAviso() {
        return this.finalAviso;
    }

    public void setFinalAviso(Date finalAviso) {
        this.finalAviso = finalAviso;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_AVISO", foreignKey=@ForeignKey(name="FK_EMISSAO_TIPO_AVISO"))
    public EsocTipoAvisoPrevio getTipoAviso() {
        return this.tipoAviso;
    }

    public void setTipoAviso(EsocTipoAvisoPrevio tipoAviso) {
        this.tipoAviso = tipoAviso;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CANCELAMENTO")
    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_CANCELAMENTO_AVISO", foreignKey=@ForeignKey(name="FK_MOT_CANCELAMENTO_AVISO"))
    public EsocMtvCancAvPrevio getMotivoCancelamentoAviso() {
        return this.motivoCancelamentoAviso;
    }

    public void setMotivoCancelamentoAviso(EsocMtvCancAvPrevio motivoCancelamentoAviso) {
        this.motivoCancelamentoAviso = motivoCancelamentoAviso;
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getTipoAviso() != null ? this.getTipoAviso().getCodigo() : "", this.getTipoAviso() != null ? this.getTipoAviso().getDescricao() : ""});
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMISSAO_AVISO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CANCELAR_AVISO")
    public Short getCancelarAviso() {
        return this.cancelarAviso;
    }

    public void setCancelarAviso(Short cancelarAviso) {
        this.cancelarAviso = cancelarAviso;
    }

    @Column(name="DATA_AFASTAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAfastamento() {
        return this.dataAfastamento;
    }

    public void setDataAfastamento(Date dataAfastamento) {
        this.dataAfastamento = dataAfastamento;
    }

    @Column(name="DIAS_REDUCAO")
    public Integer getDiasReducao() {
        return this.diasReducao;
    }

    public void setDiasReducao(Integer diasReducao) {
        this.diasReducao = diasReducao;
    }

    @Column(name="DIAS_AVISO", precision=15, scale=2)
    public Double getDiasAviso() {
        return this.diasAviso;
    }

    public void setDiasAviso(Double diasAviso) {
        this.diasAviso = diasAviso;
    }

    @Override
    @OneToMany(mappedBy="emissaoAviso")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }
}

