/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.QueryWeb;
import com.touchcomp.basementor.annotations.QueryWebFields;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.GrupoEmpresasRelEmp;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="EMPRESA", uniqueConstraints={@UniqueConstraint(name="UNQ1_EMPRESA", columnNames={"ID_PESSOA"})})
@QueryWeb(fields={@QueryWebFields(fieldName="pessoa.nome")})
public class Empresa
implements InterfaceVO {
    private Long identificador;
    private EmpresaDados empresaDados;
    private Pessoa pessoa;
    private String siglaEmpresa;
    private List<GrupoEmpresasRelEmp> grupoEmpresasRel = new ArrayList<GrupoEmpresasRelEmp>();
    private Timestamp dataAtualizacao;
    private Date dataUltModificacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_EMP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMPRESA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_EMPRESA_DADOS", foreignKey=@ForeignKey(name="FK_EMPRESA_EMP_DADOS"))
    public EmpresaDados getEmpresaDados() {
        return this.empresaDados;
    }

    public void setEmpresaDados(EmpresaDados empresaDados) {
        this.empresaDados = empresaDados;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_EMPRESA_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getPessoa() != null && this.getPessoa().getNomeFantasia() != null && this.getPessoa().getNomeFantasia().trim().length() > 0) {
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNomeFantasia() : this.getPessoa()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="empresa", fetch=FetchType.LAZY)
    public List<GrupoEmpresasRelEmp> getGrupoEmpresasRel() {
        return this.grupoEmpresasRel;
    }

    public void setGrupoEmpresasRel(List<GrupoEmpresasRelEmp> grupoEmpresasRel) {
        this.grupoEmpresasRel = grupoEmpresasRel;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="SIGLA_EMPRESA", length=10)
    public String getSiglaEmpresa() {
        return this.siglaEmpresa;
    }

    public void setSiglaEmpresa(String siglaEmpresa) {
        this.siglaEmpresa = siglaEmpresa;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ULT_MODIFICACAO")
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }
}

