/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="EMPRESA_FINANCEIRA", uniqueConstraints={@UniqueConstraint(name="UNQ1_EMPRESA_FINANCEIRA", columnNames={"ID_EMPRESA"})})
public class EmpresaFinanceiro
implements InterfaceVO {
    private static long serialVersionUID = 1595246543970434657L;
    private Long identificador;
    private Empresa empresa;
    private List<ContaValores> contaValores = new ArrayList<ContaValores>();
    private Short formaAntecipacaoTitulo = 0;
    private Short alterarLancGerGeradoMentor = 0;
    private PlanoContaGerencial planoGerencialTituloAntecipado;
    private PlanoConta pcAntecipacaoRec;
    private PlanoConta pcAntecipacaoPag;
    private PlanoContaGerencial planoGNRE;
    private PlanoConta contaPrescricaoCheque;

    @Id
    @Column(name="ID_EMPRESA_FINANCEIRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMPRESA_FINANCEIRO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long idEmp) {
        this.identificador = idEmp;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_FINANC_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="EMP_FINANCEIRO_CONTA_VALOR", joinColumns={@JoinColumn(name="ID_EMP_FINANCEIRO")}, inverseJoinColumns={@JoinColumn(name="ID_CONTA_VALORES")})
    public List<ContaValores> getContaValores() {
        return this.contaValores;
    }

    public void setContaValores(List<ContaValores> contaValores) {
        this.contaValores = contaValores;
    }

    @Column(name="FORMA_ANTECIPACAO")
    public Short getFormaAntecipacaoTitulo() {
        return this.formaAntecipacaoTitulo;
    }

    public void setFormaAntecipacaoTitulo(Short formaAntecipacaoTitulo) {
        this.formaAntecipacaoTitulo = formaAntecipacaoTitulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ALTERAR_LANC_GER_GERADO_MENTOR")
    public Short getAlterarLancGerGeradoMentor() {
        return this.alterarLancGerGeradoMentor;
    }

    public void setAlterarLancGerGeradoMentor(Short alterarLancGerGeradoMentor) {
        this.alterarLancGerGeradoMentor = alterarLancGerGeradoMentor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GER_TITULO_ANTECIPADO", foreignKey=@ForeignKey(name="FK_EMP_FIN_PL_GER_TITULO_ANTECI"))
    public PlanoContaGerencial getPlanoGerencialTituloAntecipado() {
        return this.planoGerencialTituloAntecipado;
    }

    public void setPlanoGerencialTituloAntecipado(PlanoContaGerencial planoGerencialTituloAntecipado) {
        this.planoGerencialTituloAntecipado = planoGerencialTituloAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_ANTECIP_PAG", foreignKey=@ForeignKey(name="FK_EMPRESA_FINANCEIRA_40"))
    public PlanoConta getPcAntecipacaoRec() {
        return this.pcAntecipacaoRec;
    }

    public void setPcAntecipacaoRec(PlanoConta pcAntecipacaoRec) {
        this.pcAntecipacaoRec = pcAntecipacaoRec;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_ANTECIP_REC", foreignKey=@ForeignKey(name="FK_EMPRESA_FINANCEIRA_41"))
    public PlanoConta getPcAntecipacaoPag() {
        return this.pcAntecipacaoPag;
    }

    public void setPcAntecipacaoPag(PlanoConta pcAntecipacaoPag) {
        this.pcAntecipacaoPag = pcAntecipacaoPag;
    }

    @JoinColumn(name="ID_PLANO_GNRE_GER", foreignKey=@ForeignKey(name="FK_EMPRESA_FINANCEIRA_33"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoGNRE() {
        return this.planoGNRE;
    }

    public void setPlanoGNRE(PlanoContaGerencial planoGNRE) {
        this.planoGNRE = planoGNRE;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PERC_CHEQUE", foreignKey=@ForeignKey(name="FK_EMP_F_PERC_CHQUE"))
    public PlanoConta getContaPrescricaoCheque() {
        return this.contaPrescricaoCheque;
    }

    public void setContaPrescricaoCheque(PlanoConta contaPrescricaoCheque) {
        this.contaPrescricaoCheque = contaPrescricaoCheque;
    }
}

