/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="ENDERECO")
public class Endereco
implements InterfaceVO {
    private Long identificador;
    private String logradouro = "";
    private String cep = "";
    private String bairro = "";
    private String numero = "";
    private String complemento = "";
    private Cidade cidade;
    private Timestamp dataAtualizacao;
    private String referencia;
    private String observacao;

    @Id
    @Column(name="ID_ENDERECO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ENDERECO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="LOGRADOURO", length=60)
    public String getLogradouro() {
        return this.logradouro;
    }

    @Column(nullable=false, name="CEP", length=9)
    public String getCep() {
        return this.cep;
    }

    @Column(nullable=false, name="BAIRRO", length=60)
    public String getBairro() {
        return this.bairro;
    }

    @Column(nullable=false, name="NUMERO", length=10)
    public String getNumero() {
        return this.numero;
    }

    @Column(nullable=true, name="COMPLEMENTO", length=60)
    public String getComplemento() {
        return this.complemento;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setIdentificador(Long idEnd) {
        this.identificador = idEnd;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getCidade() != null && this.getCidade().getUf() != null) {
            return ToolBaseMethodsVO.toString((String)"{0},numero {1}, {2},bairro {3},{4}/{5}", (Object[])new Object[]{this.getLogradouro(), this.getNumero(), this.getComplemento(), this.getBairro(), this.getCidade(), this.getCidade().getUf().getSigla()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}, numero {1},{2}", (Object[])new Object[]{this.getLogradouro(), this.getNumero(), this.getComplemento()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE", foreignKey=@ForeignKey(name="FK_ENDERECO_CIDADE"))
    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=true, name="REFERENCIA", length=200)
    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    @Column(nullable=true, name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

