/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocAmbienteTrabalhoCC;
import com.touchcomp.basementor.model.vo.EsocAmbienteTrabalhoDepartamentoColaborador;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocLocalAmbTrab;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="ESOC_AMBIENTE_TRABALHO")
public class EsocAmbienteTrabalho
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String codigoInformado;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short infCodigoManual = 0;
    private EsocLocalAmbTrab esocLocalAmbiente;
    private EsocCadastroLotacaoTributaria lotacaoTributaria;
    private String descricaoAmbiente;
    private List<EsocAmbienteTrabalhoCC> centroCustos = new ArrayList<EsocAmbienteTrabalhoCC>();
    private List<EsocAmbienteTrabalhoDepartamentoColaborador> esocAmbienteTrabalhoDepartamentoColaborador = new ArrayList<EsocAmbienteTrabalhoDepartamentoColaborador>();

    @Id
    @Column(name="ID_ESOC_AMBIENTE_TRABALHO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_AMBIENTE_TRABALHO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(insertable=false, updatable=false, unique=true, name="CODIGO", length=250)
    @Generated(value=GenerationTime.ALWAYS)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Column(name="CODIGO_INFORMADO", length=250)
    public String getCodigoInformado() {
        return this.codigoInformado;
    }

    public void setCodigoInformado(String codigoInformado) {
        this.codigoInformado = codigoInformado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_AMB_TRAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INF_CODIGO_MANUAL")
    public Short getInfCodigoManual() {
        return this.infCodigoManual;
    }

    public void setInfCodigoManual(Short infCodigoManual) {
        this.infCodigoManual = infCodigoManual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_LOCAL_AMB_TRAB", foreignKey=@ForeignKey(name="FK_ESOC_AMB_TRAB_LOCAL_AMB"))
    public EsocLocalAmbTrab getEsocLocalAmbiente() {
        return this.esocLocalAmbiente;
    }

    public void setEsocLocalAmbiente(EsocLocalAmbTrab esocLocalAmbiente) {
        this.esocLocalAmbiente = esocLocalAmbiente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CADASTRO_LOTACAO_TRIB", foreignKey=@ForeignKey(name="FK_ESOC_AMB_TRAB_LOT_TRIB"))
    public EsocCadastroLotacaoTributaria getLotacaoTributaria() {
        return this.lotacaoTributaria;
    }

    public void setLotacaoTributaria(EsocCadastroLotacaoTributaria lotacaoTributaria) {
        this.lotacaoTributaria = lotacaoTributaria;
    }

    @Column(name="DESCRICAO_AMBIENTE", length=8000)
    public String getDescricaoAmbiente() {
        return this.descricaoAmbiente;
    }

    public void setDescricaoAmbiente(String descricaoAmbiente) {
        this.descricaoAmbiente = descricaoAmbiente;
    }

    public String toString() {
        return ToolMethods.isNotNull((Object)this.getLotacaoTributaria()) != false ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getLotacaoTributaria().getIdentificador(), ToolMethods.isNotNull((Object)this.getLotacaoTributaria().getPessoa()) != false ? this.getLotacaoTributaria().getPessoa().getNome() : this.getLotacaoTributaria().getEmpresa().getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getCodigo()});
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="esocAmbiente")
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<EsocAmbienteTrabalhoCC> getCentroCustos() {
        return this.centroCustos;
    }

    public void setCentroCustos(List<EsocAmbienteTrabalhoCC> centroCustos) {
        this.centroCustos = centroCustos;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="esocAmbienteTrabalho")
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<EsocAmbienteTrabalhoDepartamentoColaborador> getEsocAmbienteTrabalhoDepartamentoColaborador() {
        return this.esocAmbienteTrabalhoDepartamentoColaborador;
    }

    public void setEsocAmbienteTrabalhoDepartamentoColaborador(List<EsocAmbienteTrabalhoDepartamentoColaborador> esocAmbienteTrabalhoDepartamentoColaborador) {
        this.esocAmbienteTrabalhoDepartamentoColaborador = esocAmbienteTrabalhoDepartamentoColaborador;
    }
}

