/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCAEPF;
import com.touchcomp.basementor.model.vo.EsocContSubPatronalObra;
import com.touchcomp.basementor.model.vo.EsocContracaoMenorAprendiz;
import com.touchcomp.basementor.model.vo.EsocIndicativoContPdo;
import com.touchcomp.basementor.model.vo.EsocOpcaoPonto;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="ESOC_CADASTRO_ESTABELECIMENTO")
public class EsocCadastroEstabelcimento
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Double aliquotaRat = 0.0;
    private Double fat = 0.0;
    private EsocOpcaoPonto opcaoPonto;
    private Short informarDadosCAEPF = 0;
    private EsocCAEPF caepf;
    private EsocContSubPatronalObra esocContPatronalobra;
    private EsocContracaoMenorAprendiz contracaoMenorAprendiz;
    private Short contratacaoAPrendizSocEducativa = 0;
    private String cnpjSocEducativa;
    private EsocIndicativoContPdo indicativoPdo;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Date dataInicio;
    private CNAE cnae;
    private Double ajusteRat = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_CAD_ESTABELECIMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_CAD_ESTABELECIMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_ESTA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="ALIQUOTA_RAT", precision=15, scale=2)
    public Double getAliquotaRat() {
        return this.aliquotaRat;
    }

    public void setAliquotaRat(Double aliquotaRat) {
        this.aliquotaRat = aliquotaRat;
    }

    @Column(name="FAT", precision=15, scale=6)
    public Double getFat() {
        return this.fat;
    }

    public void setFat(Double fat) {
        this.fat = fat;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OPCAO_PONTO", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_EST_PONTO"))
    public EsocOpcaoPonto getOpcaoPonto() {
        return this.opcaoPonto;
    }

    public void setOpcaoPonto(EsocOpcaoPonto opcaoPonto) {
        this.opcaoPonto = opcaoPonto;
    }

    @Column(name="INFORMAR_DADOS_CAEPF")
    public Short getInformarDadosCAEPF() {
        return this.informarDadosCAEPF;
    }

    public void setInformarDadosCAEPF(Short informarDadosCAEPF) {
        this.informarDadosCAEPF = informarDadosCAEPF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DADOS_CAEPF", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_EST_CAEPF"))
    public EsocCAEPF getCaepf() {
        return this.caepf;
    }

    public void setCaepf(EsocCAEPF caepf) {
        this.caepf = caepf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CONT_PATRONAL", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_ESTA_PATRONAL"))
    public EsocContSubPatronalObra getEsocContPatronalobra() {
        return this.esocContPatronalobra;
    }

    public void setEsocContPatronalobra(EsocContSubPatronalObra esocContPatronalobra) {
        this.esocContPatronalobra = esocContPatronalobra;
    }

    @Column(name="CONTRATACAO_A_APRENDIZ_EDUC")
    public Short getContratacaoAPrendizSocEducativa() {
        return this.contratacaoAPrendizSocEducativa;
    }

    public void setContratacaoAPrendizSocEducativa(Short contratacaoAPrendizSocEducativa) {
        this.contratacaoAPrendizSocEducativa = contratacaoAPrendizSocEducativa;
    }

    @Column(name="CNPJ_SOC_EDUCATIVA", length=24)
    public String getCnpjSocEducativa() {
        return this.cnpjSocEducativa;
    }

    public void setCnpjSocEducativa(String cnpjSocEducativa) {
        this.cnpjSocEducativa = cnpjSocEducativa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONT_MENOR_APRENDIZ", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_ESTA_APRENDIZ"))
    public EsocContracaoMenorAprendiz getContracaoMenorAprendiz() {
        return this.contracaoMenorAprendiz;
    }

    public void setContracaoMenorAprendiz(EsocContracaoMenorAprendiz contracaoMenorAprendiz) {
        this.contracaoMenorAprendiz = contracaoMenorAprendiz;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICATIVO_PDO", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_ESTA_PCD"))
    public EsocIndicativoContPdo getIndicativoPdo() {
        return this.indicativoPdo;
    }

    public void setIndicativoPdo(EsocIndicativoContPdo indicativoPdo) {
        this.indicativoPdo = indicativoPdo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getEmpresa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Override
    @OneToMany(mappedBy="estabelecimento")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO")
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_EST_CNAE_E_SOCIAL"))
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @Column(name="AJUSTE_RAT", precision=15, scale=5)
    public Double getAjusteRat() {
        return this.ajusteRat;
    }

    public void setAjusteRat(Double ajusteRat) {
        this.ajusteRat = ajusteRat;
    }
}

