/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EsocBasesAquiProdRural;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocLotacaoTributaria5011;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.EsocValoresContSociaisDevidas;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESOC_ESTABELECIMENTOS_5011")
public class EsocEstabelecimentos5011
implements InterfaceVO {
    private Long identificador;
    private EsocValores5011 esocValores;
    private EsocCadastroEstabelcimento estabelecimento;
    private String numeroCnpj;
    private List<EsocLotacaoTributaria5011> lotacoes = new ArrayList<EsocLotacaoTributaria5011>();
    private List<EsocValoresContSociaisDevidas> valoresDevidos = new ArrayList<EsocValoresContSociaisDevidas>();
    private List<EsocBasesAquiProdRural> basesAquiProdRural = new ArrayList<EsocBasesAquiProdRural>();

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_ESTABELECIMENTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_ESTABELECIMENTOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_VALORES_5011", foreignKey=@ForeignKey(name="FK_ESOC_VALORES_5011_LOTACAO"))
    public EsocValores5011 getEsocValores() {
        return this.esocValores;
    }

    public void setEsocValores(EsocValores5011 esocValores) {
        this.esocValores = esocValores;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTABELECIMENTO", foreignKey=@ForeignKey(name="FK_ESTABELECIMENTO_TOT_INSS"))
    public EsocCadastroEstabelcimento getEstabelecimento() {
        return this.estabelecimento;
    }

    public void setEstabelecimento(EsocCadastroEstabelcimento estabelecimento) {
        this.estabelecimento = estabelecimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CNPJ", length=20)
    public String getNumeroCnpj() {
        return this.numeroCnpj;
    }

    public void setNumeroCnpj(String numeroCnpj) {
        this.numeroCnpj = numeroCnpj;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="estabelecimento", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocLotacaoTributaria5011> getLotacoes() {
        return this.lotacoes;
    }

    public void setLotacoes(List<EsocLotacaoTributaria5011> lotacoes) {
        this.lotacoes = lotacoes;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="esocEstabelecimento", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocValoresContSociaisDevidas> getValoresDevidos() {
        return this.valoresDevidos;
    }

    public void setValoresDevidos(List<EsocValoresContSociaisDevidas> valoresDevidos) {
        this.valoresDevidos = valoresDevidos;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="esocEstabelecimento", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocBasesAquiProdRural> getBasesAquiProdRural() {
        return this.basesAquiProdRural;
    }

    public void setBasesAquiProdRural(List<EsocBasesAquiProdRural> basesAquiProdRural) {
        this.basesAquiProdRural = basesAquiProdRural;
    }
}

