/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroMedicoResponsavel;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ESOC_EXAME_TOXICOLOGICO")
public class EsocExameToxicologico
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Colaborador colaborador;
    private Date dataExame;
    private Pessoa pessoaLaboratorio;
    private String codigoExame;
    private EsocCadastroMedicoResponsavel esocCadastroMedicoResponsavel;
    private Short houveRecusa = 0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();

    @Id
    @Column(nullable=false, name="ID_ESOC_EXAME_TOXICOLOGICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_EXAME_TOXICOLOGICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_EXAME_TOX_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_ESOC_EXAME_TOX_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EXAME")
    public Date getDataExame() {
        return this.dataExame;
    }

    public void setDataExame(Date dataExame) {
        this.dataExame = dataExame;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_LABORATORIO", foreignKey=@ForeignKey(name="FK_ESOC_EXAME_TOX_PESSOA_LAB"))
    public Pessoa getPessoaLaboratorio() {
        return this.pessoaLaboratorio;
    }

    public void setPessoaLaboratorio(Pessoa pessoaLaboratorio) {
        this.pessoaLaboratorio = pessoaLaboratorio;
    }

    @Column(name="CODIGO_EXAME", length=11)
    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CAD_MEDICO_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_ESOC_EXAME_TOX_ESOC_CAD_MED"))
    public EsocCadastroMedicoResponsavel getEsocCadastroMedicoResponsavel() {
        return this.esocCadastroMedicoResponsavel;
    }

    public void setEsocCadastroMedicoResponsavel(EsocCadastroMedicoResponsavel esocCadastroMedicoResponsavel) {
        this.esocCadastroMedicoResponsavel = esocCadastroMedicoResponsavel;
    }

    @Column(nullable=false, name="HOUVE_RECUSA")
    public Short getHouveRecusa() {
        return this.houveRecusa;
    }

    public void setHouveRecusa(Short houveRecusa) {
        this.houveRecusa = houveRecusa;
    }

    @Override
    @OneToMany(mappedBy="exameToxicologico")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

