/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESOC_FECHAMENTO_FOLHA")
public class EsocFechamentoFolha
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualiazacao;
    private GrupoEmpresa grupoEmpresa;
    private Date periodoApuracao;
    private List<EsocS1010> esocS1010 = new ArrayList<EsocS1010>();
    private List<ESocS1020> esocS1020 = new ArrayList<ESocS1020>();
    private Short gerarInformacoesComplementares = 0;
    private Short gerarEventos1200 = 0;
    private Short gerarEventos1210 = 0;
    private Short tipoSubstituicao = ConstantsESocial.S1280_SUBSTITUIDA_INTEGRALMENTE;
    private Double percentualReducao = 0.0;
    private Double fatorMes = 0.0;
    private Double fatorMes13 = 0.0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Short tipoFolha = EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_FECHAMENTO_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_FECHAMENTO_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_FEC_FOLHA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualiazacao() {
        return this.dataAtualiazacao;
    }

    public void setDataAtualiazacao(Timestamp dataAtualiazacao) {
        this.dataAtualiazacao = dataAtualiazacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_FEC_FOLHA_GRUPO_EMP"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Column(name="PERIODO_APURACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoApuracao() {
        return this.periodoApuracao;
    }

    public void setPeriodoApuracao(Date periodoApuracao) {
        this.periodoApuracao = periodoApuracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="esocFechamentoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocS1010> getEsocS1010() {
        return this.esocS1010;
    }

    public void setEsocS1010(List<EsocS1010> esocS1010) {
        this.esocS1010 = esocS1010;
    }

    @OneToMany(mappedBy="esocFechamento", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ESocS1020> getEsocS1020() {
        return this.esocS1020;
    }

    public void setEsocS1020(List<ESocS1020> esocS1020) {
        this.esocS1020 = esocS1020;
    }

    @Column(name="FATOR_MES", precision=15, scale=2)
    public Double getFatorMes() {
        return this.fatorMes;
    }

    public void setFatorMes(Double fatorMes) {
        this.fatorMes = fatorMes;
    }

    @Column(name="GERAR_INFORMACOES_COMPLEMENTARE")
    public Short getGerarInformacoesComplementares() {
        return this.gerarInformacoesComplementares;
    }

    public void setGerarInformacoesComplementares(Short gerarInformacoesComplementares) {
        this.gerarInformacoesComplementares = gerarInformacoesComplementares;
    }

    @Column(name="TIPO_SUBSTITUICAO")
    public Short getTipoSubstituicao() {
        return this.tipoSubstituicao;
    }

    public void setTipoSubstituicao(Short tipoSubstituicao) {
        this.tipoSubstituicao = tipoSubstituicao;
    }

    @Column(name="PERCENTUAL_REDUCAO", precision=15, scale=2)
    public Double getPercentualReducao() {
        return this.percentualReducao;
    }

    public void setPercentualReducao(Double percentualReducao) {
        this.percentualReducao = percentualReducao;
    }

    @Column(name="FATOR_MES_13", precision=15, scale=2)
    public Double getFatorMes13() {
        return this.fatorMes13;
    }

    public void setFatorMes13(Double fatorMes13) {
        this.fatorMes13 = fatorMes13;
    }

    @Override
    @OneToMany(mappedBy="esocFechamentoFolha")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="GERAR_EVENTOS_1200")
    public Short getGerarEventos1200() {
        return this.gerarEventos1200;
    }

    public void setGerarEventos1200(Short gerarEventos1200) {
        this.gerarEventos1200 = gerarEventos1200;
    }

    @Column(name="GERAR_EVENTOS_1210")
    public Short getGerarEventos1210() {
        return this.gerarEventos1210;
    }

    public void setGerarEventos1210(Short gerarEventos1210) {
        this.gerarEventos1210 = gerarEventos1210;
    }

    @Column(name="TIPO_FOLHA")
    public Short getTipoFolha() {
        return this.tipoFolha;
    }

    public void setTipoFolha(Short tipoFolha) {
        this.tipoFolha = tipoFolha;
    }
}

