/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.processotrabalhista.EnumConstIndicativoRepercussao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Abono;
import com.touchcomp.basementor.model.vo.BaseCalculoContribPrevidenciaria;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.InformacoesFGTS;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Remuneracao;
import com.touchcomp.basementor.model.vo.TipoContrato;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESOC_PROCESSO_TRABALHISTA")
public class EsocProcessoTrabalhista
implements InterfaceVO,
InterfaceVOEsocial {
    @Id
    @Column(nullable=false, name="ID_ESOC_PROC_TRABALHISTA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_PROC_TRBALHISTA")
    private Long identificador;
    @Column(nullable=false, name="ORIGEM")
    private Short origem;
    @Column(name="DATA_SENTENCA")
    @Temporal(value=TemporalType.DATE)
    private Date dtSent;
    @Column(name="TP_CCP")
    private Short tpCCP;
    @Column(name="DT_CCP")
    private Date dtCCP;
    @Column(name="CNPJ_CCP", length=18)
    private String cnpjCCP;
    @Column(name="NR_PROC_TRAB", length=20)
    private String nrProcTrab;
    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro;
    @Column(nullable=false, name="COMPETENCIA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    private Date competenciaInicial;
    @Column(nullable=false, name="COMPETENCIA_FINAL")
    @Temporal(value=TemporalType.DATE)
    private Date competenciaFinal;
    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_PROC_TRAB_EMPRESA"))
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_RECISAO", foreignKey=@ForeignKey(name="FK_ESOC_PROC_TRAB_RECIS"))
    private Recisao recisao;
    @Column(name="OBS_PROC_TRAB", length=10000)
    private String obsProcTrab;
    @Column(name="IND_CONTR")
    private Short indContr;
    @Column(name="IND_REINT")
    private Short indReint;
    @Column(name="IND_CATEG")
    private Short indCateg;
    @Column(name="IND_NAT_ATIV")
    private Short indNatAtiv;
    @Column(name="IND_MOT_DELISG")
    private Short indMotDelisg;
    @Column(name="INDEN_SD")
    private Short indenSD;
    @Column(name="INDEN_ABONO")
    private Short indenAbono;
    @Column(name="ID_VARA")
    private Long idVara;
    @Column(name="IND_REPERC")
    private Short indReperc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TIPO_CONTRATO", foreignKey=@ForeignKey(name="FK_ESOC_PROC_TRAB_TP_CONTR"))
    private TipoContrato tipoContrato;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CIDADE", foreignKey=@ForeignKey(name="FK_ESOC_PROC_TRAB_CIDADE"))
    private Cidade cidade;
    @OneToMany(mappedBy="processoTrabalhista", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<Remuneracao> remuneracoes;
    @OneToMany(mappedBy="processoTrabalhista", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<Abono> abonos;
    @OneToMany(mappedBy="processoTrabalhista", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<BaseCalculoContribPrevidenciaria> baseCalculoContribPrevidenciarias;
    @OneToMany(mappedBy="processoTrabalhista", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<InformacoesFGTS> informacoesFGTS;
    @OneToMany(mappedBy="processoTrabalhista")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<EsocPreEvento> preEventosEsocial;

    public EsocProcessoTrabalhista() {
        this.setInformacoesFGTS(new ArrayList<InformacoesFGTS>());
        this.setPreEventosEsocial(new ArrayList<EsocPreEvento>());
        this.setBaseCalculoContribPrevidenciarias(new ArrayList<BaseCalculoContribPrevidenciaria>());
        this.setAbonos(new ArrayList<Abono>());
        this.setRemuneracoes(new ArrayList<Remuneracao>());
        this.setDataCadastro(new Date());
        this.setOrigem(EnumConstantsMentorSimNao.SIM.getValue());
        this.setTpCCP(EnumConstantsMentorSimNao.SIM.getValue());
        this.setIndContr(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndReint(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndCateg(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndNatAtiv(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndMotDelisg(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndenSD(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndenAbono(EnumConstantsMentorSimNao.NAO.getValue());
        this.setIndReperc(EnumConstIndicativoRepercussao.SEM.getEnumId());
        this.setIdVara(0L);
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Override
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Short getOrigem() {
        return this.origem;
    }

    @Generated
    public Date getDtSent() {
        return this.dtSent;
    }

    @Generated
    public Short getTpCCP() {
        return this.tpCCP;
    }

    @Generated
    public Date getDtCCP() {
        return this.dtCCP;
    }

    @Generated
    public String getCnpjCCP() {
        return this.cnpjCCP;
    }

    @Generated
    public String getNrProcTrab() {
        return this.nrProcTrab;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getCompetenciaInicial() {
        return this.competenciaInicial;
    }

    @Generated
    public Date getCompetenciaFinal() {
        return this.competenciaFinal;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Recisao getRecisao() {
        return this.recisao;
    }

    @Generated
    public String getObsProcTrab() {
        return this.obsProcTrab;
    }

    @Generated
    public Short getIndContr() {
        return this.indContr;
    }

    @Generated
    public Short getIndReint() {
        return this.indReint;
    }

    @Generated
    public Short getIndCateg() {
        return this.indCateg;
    }

    @Generated
    public Short getIndNatAtiv() {
        return this.indNatAtiv;
    }

    @Generated
    public Short getIndMotDelisg() {
        return this.indMotDelisg;
    }

    @Generated
    public Short getIndenSD() {
        return this.indenSD;
    }

    @Generated
    public Short getIndenAbono() {
        return this.indenAbono;
    }

    @Generated
    public Long getIdVara() {
        return this.idVara;
    }

    @Generated
    public Short getIndReperc() {
        return this.indReperc;
    }

    @Generated
    public TipoContrato getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public List<Remuneracao> getRemuneracoes() {
        return this.remuneracoes;
    }

    @Generated
    public List<Abono> getAbonos() {
        return this.abonos;
    }

    @Generated
    public List<BaseCalculoContribPrevidenciaria> getBaseCalculoContribPrevidenciarias() {
        return this.baseCalculoContribPrevidenciarias;
    }

    @Generated
    public List<InformacoesFGTS> getInformacoesFGTS() {
        return this.informacoesFGTS;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setOrigem(Short origem) {
        this.origem = origem;
    }

    @Generated
    public void setDtSent(Date dtSent) {
        this.dtSent = dtSent;
    }

    @Generated
    public void setTpCCP(Short tpCCP) {
        this.tpCCP = tpCCP;
    }

    @Generated
    public void setDtCCP(Date dtCCP) {
        this.dtCCP = dtCCP;
    }

    @Generated
    public void setCnpjCCP(String cnpjCCP) {
        this.cnpjCCP = cnpjCCP;
    }

    @Generated
    public void setNrProcTrab(String nrProcTrab) {
        this.nrProcTrab = nrProcTrab;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setCompetenciaInicial(Date competenciaInicial) {
        this.competenciaInicial = competenciaInicial;
    }

    @Generated
    public void setCompetenciaFinal(Date competenciaFinal) {
        this.competenciaFinal = competenciaFinal;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setRecisao(Recisao recisao) {
        this.recisao = recisao;
    }

    @Generated
    public void setObsProcTrab(String obsProcTrab) {
        this.obsProcTrab = obsProcTrab;
    }

    @Generated
    public void setIndContr(Short indContr) {
        this.indContr = indContr;
    }

    @Generated
    public void setIndReint(Short indReint) {
        this.indReint = indReint;
    }

    @Generated
    public void setIndCateg(Short indCateg) {
        this.indCateg = indCateg;
    }

    @Generated
    public void setIndNatAtiv(Short indNatAtiv) {
        this.indNatAtiv = indNatAtiv;
    }

    @Generated
    public void setIndMotDelisg(Short indMotDelisg) {
        this.indMotDelisg = indMotDelisg;
    }

    @Generated
    public void setIndenSD(Short indenSD) {
        this.indenSD = indenSD;
    }

    @Generated
    public void setIndenAbono(Short indenAbono) {
        this.indenAbono = indenAbono;
    }

    @Generated
    public void setIdVara(Long idVara) {
        this.idVara = idVara;
    }

    @Generated
    public void setIndReperc(Short indReperc) {
        this.indReperc = indReperc;
    }

    @Generated
    public void setTipoContrato(TipoContrato tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setRemuneracoes(List<Remuneracao> remuneracoes) {
        this.remuneracoes = remuneracoes;
    }

    @Generated
    public void setAbonos(List<Abono> abonos) {
        this.abonos = abonos;
    }

    @Generated
    public void setBaseCalculoContribPrevidenciarias(List<BaseCalculoContribPrevidenciaria> baseCalculoContribPrevidenciarias) {
        this.baseCalculoContribPrevidenciarias = baseCalculoContribPrevidenciarias;
    }

    @Generated
    public void setInformacoesFGTS(List<InformacoesFGTS> informacoesFGTS) {
        this.informacoesFGTS = informacoesFGTS;
    }

    @Generated
    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }
}

