/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cbo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocTipoProfissional;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="ESOC_RESP_TREINAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ_ESOC_RESP_TREIN_PESSOA_CBO", columnNames={"ID_PESSOA", "ID_CBO"})})
public class EsocRespTreinamento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Pessoa pessoa;
    private EsocTipoProfissional tipoProfissional;
    private String tipoFormacao;
    private Cbo cbo;
    private Short nacionalidade = ConstantsESocial.ESOC_NACIONALIDADE_BRASILEIRO;

    @Id
    @Column(name="ID_ESOC_RESP_TREINAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_RESP_TREINAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_RESP_TREIN_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ESOC_RESP_TREIN_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PROFISSIONAL", foreignKey=@ForeignKey(name="FK_ESOC_RESP_TREIN_TIPO_TREIN"))
    public EsocTipoProfissional getTipoProfissional() {
        return this.tipoProfissional;
    }

    public void setTipoProfissional(EsocTipoProfissional tipoProfissional) {
        this.tipoProfissional = tipoProfissional;
    }

    @Column(name="TIPO_FORMACAO", length=255)
    public String getTipoFormacao() {
        return this.tipoFormacao;
    }

    public void setTipoFormacao(String tipoFormacao) {
        this.tipoFormacao = tipoFormacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(unique=true, name="ID_CBO", foreignKey=@ForeignKey(name="FK_ESOC_RESP_TREIN_CBO"))
    public Cbo getCbo() {
        return this.cbo;
    }

    public void setCbo(Cbo cbo) {
        this.cbo = cbo;
    }

    @Column(name="NACIONALIDADE")
    public Short getNacionalidade() {
        return this.nacionalidade;
    }

    public void setNacionalidade(Short nacionalidade) {
        this.nacionalidade = nacionalidade;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNome() : ""});
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

