/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPer;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="ESTRUTURA_ORCAMENTARIA")
public class EstruturaOrcamentaria
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_ESTRUTURA_ORCAMENTARIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESTRUTURA_ORCAMENTARIA")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    private Date dataCadastro;
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO")
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESTRUTURA_ORC_EMPRESA"))
    private Empresa empresa;
    @Column(name="DESCRICAO", length=1000)
    private String descricao;
    @Column(name="REVISAO", length=500)
    private String revisao;
    @Column(name="TRAVAR_ESTRUTURA")
    private Short travarEstrutura = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICE_GERENCIAL", foreignKey=@ForeignKey(name="FK_ESTRUTURA_ORC_IND_GERENCIAL"))
    private IndiceGerencial indiceGerencial;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERVALO_CONTROLE_GER", foreignKey=@ForeignKey(name="FK_ESTRUTURA_ORC_INTER_CONT_GER"))
    private IntervaloControleGer intervaloControleGer;
    @Column(name="OBSERVACAO", length=1000)
    private String observacao;
    @OneToMany(mappedBy="estruturaOrcamentaria", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EstruturaOrcamentariaPer> estruturaOrcamentariaPeriodos = new LinkedList<EstruturaOrcamentariaPer>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getRevisao() {
        return this.revisao;
    }

    @Generated
    public Short getTravarEstrutura() {
        return this.travarEstrutura;
    }

    @Generated
    public IndiceGerencial getIndiceGerencial() {
        return this.indiceGerencial;
    }

    @Generated
    public IntervaloControleGer getIntervaloControleGer() {
        return this.intervaloControleGer;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<EstruturaOrcamentariaPer> getEstruturaOrcamentariaPeriodos() {
        return this.estruturaOrcamentariaPeriodos;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setRevisao(String revisao) {
        this.revisao = revisao;
    }

    @Generated
    public void setTravarEstrutura(Short travarEstrutura) {
        this.travarEstrutura = travarEstrutura;
    }

    @Generated
    public void setIndiceGerencial(IndiceGerencial indiceGerencial) {
        this.indiceGerencial = indiceGerencial;
    }

    @Generated
    public void setIntervaloControleGer(IntervaloControleGer intervaloControleGer) {
        this.intervaloControleGer = intervaloControleGer;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setEstruturaOrcamentariaPeriodos(List<EstruturaOrcamentariaPer> estruturaOrcamentariaPeriodos) {
        this.estruturaOrcamentariaPeriodos = estruturaOrcamentariaPeriodos;
    }
}

