/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="EVENTO_COLABORADOR")
public class EventoColaborador
implements InterfaceVO {
    private Long identificador;
    private Colaborador colaborador;
    private TipoCalculoEvento tipoCalculoEvento;
    private Short tipoOcorrencia = 2;
    private Date dataInicial;
    private Date dataFinal;
    private Short mes = 0;
    private Double valor = 0.0;
    private CadastroEventoConsignado eventoConsignado;
    private Short eventoFixo = 0;
    private Short ativo = 1;
    private Short informarReferencia = 0;
    private Double referencia = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_EVENTO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_EVENTO_COLABORADOR_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_EVENTO_COLABORADOR_TP_C_EVT"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="TIPO_OCORRENCIA")
    public Short getTipoOcorrencia() {
        return this.tipoOcorrencia;
    }

    public void setTipoOcorrencia(Short tipoOcorrencia) {
        this.tipoOcorrencia = tipoOcorrencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="MES")
    public Short getMes() {
        return this.mes;
    }

    public void setMes(Short mes) {
        this.mes = mes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=4)
    public Double getValor() {
        this.valor = this.valor == null || this.valor <= 0.0 ? 0.0 : this.valor;
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_EVENTO_CONSIGNADO", foreignKey=@ForeignKey(name="FK_EVENTO_COLABORADOR_CONSIGNAD"))
    public CadastroEventoConsignado getEventoConsignado() {
        return this.eventoConsignado;
    }

    public void setEventoConsignado(CadastroEventoConsignado eventoConsignado) {
        this.eventoConsignado = eventoConsignado;
    }

    @Column(name="EVENTO_FIXO")
    public Short getEventoFixo() {
        return this.eventoFixo;
    }

    public void setEventoFixo(Short eventoFixo) {
        this.eventoFixo = eventoFixo;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="INFORMAR_REFERENCIA")
    public Short getInformarReferencia() {
        return this.informarReferencia;
    }

    public void setInformarReferencia(Short informarReferencia) {
        this.informarReferencia = informarReferencia;
    }

    @Column(nullable=false, name="REFERENCIA", precision=15, scale=2)
    public Double getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Double referencia) {
        this.referencia = referencia;
    }
}

