/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoEvtOsPCP;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EvtOSSobEncomendaEquip;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FichaTecEvtOSSobEncomenda;
import com.touchcomp.basementor.model.vo.ItemCompCustoEvtEnc;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EVENTO_OS_PROD_SOB_ENC")
public class EventoOsProdSobEnc
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataAbertura;
    private Date dataFechamento;
    private TipoEvento tipoEvento;
    private FaseProdutiva faseProdutiva;
    private Double horasInformada = 0.0;
    private Double horasNaoProdutiva = 0.0;
    private Double ajusteHorasNaoProdutiva = 0.0;
    private Double horaEvento = 0.0;
    private SubdivisaoOSProdSobEnc subdivisaoOSProdSobEnc;
    private List<ColaboradorEvtOsProdSobEnc> colaboradoresEvtProd = new ArrayList<ColaboradorEvtOsProdSobEnc>();
    private ComunicadoProducao comunicadoProducao;
    private List<ItemCompCustoEvtEnc> itemCompCustoEvtEnc = new ArrayList<ItemCompCustoEvtEnc>();
    private List<FichaTecEvtOSSobEncomenda> fichasTecnicas;
    private List<EvtOSSobEncomendaEquip> equipamentos;
    private Short tipoApontEvento = 5;
    private List<ItemEventoOsProdSobEnc> itemEventoOsProdSobEnc = new ArrayList<ItemEventoOsProdSobEnc>();
    private Short fecharSubOS = 0;
    private TurnoDeTrabalho turnoDeTrabalho;
    private String codigoBarras;
    private ClassificacaoEvtOsPCP classificacaoEvento;
    private Short origemEvento;

    public EventoOsProdSobEnc() {
        this.fichasTecnicas = new ArrayList<FichaTecEvtOSSobEncomenda>();
        this.equipamentos = new ArrayList<EvtOSSobEncomendaEquip>();
        this.origemEvento = EnumConstOrigemEventoOSProd.COMPLETO.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_EVENTO_OS_PROD_SOB_ENC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_OS_PROD_SOB_ENC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_ABERTURA")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ENCERRAMENTO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_TIPO_EVENTO", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_TP_EVT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEvento getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEvento tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Column(nullable=false, name="HORAS_INFORMADAS", precision=15, scale=4)
    public Double getHorasInformada() {
        return this.horasInformada;
    }

    public void setHorasInformada(Double horasInformada) {
        this.horasInformada = horasInformada;
    }

    @Column(nullable=false, name="HORAS_NAO_PRODUTIVA", precision=15, scale=4)
    public Double getHorasNaoProdutiva() {
        return this.horasNaoProdutiva;
    }

    public void setHorasNaoProdutiva(Double horasNaoProdutiva) {
        this.horasNaoProdutiva = horasNaoProdutiva;
    }

    @Column(nullable=false, name="AJUSTE_HORAS_NAO_PRODUTIVA", precision=15, scale=4)
    public Double getAjusteHorasNaoProdutiva() {
        return this.ajusteHorasNaoProdutiva;
    }

    public void setAjusteHorasNaoProdutiva(Double ajusteHorasNaoProdutiva) {
        this.ajusteHorasNaoProdutiva = ajusteHorasNaoProdutiva;
    }

    @Column(nullable=false, name="HORA_EVENTO", precision=12, scale=4)
    public Double getHoraEvento() {
        return this.horaEvento;
    }

    public void setHoraEvento(Double horaEvento) {
        this.horaEvento = horaEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FASE_PRODUTIVA", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_F_PROD"))
    public FaseProdutiva getFaseProdutiva() {
        return this.faseProdutiva;
    }

    public void setFaseProdutiva(FaseProdutiva faseProdutiva) {
        this.faseProdutiva = faseProdutiva;
    }

    @OneToMany(mappedBy="eventoOsProdSobEnc", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ColaboradorEvtOsProdSobEnc> getColaboradoresEvtProd() {
        return this.colaboradoresEvtProd;
    }

    public void setColaboradoresEvtProd(List<ColaboradorEvtOsProdSobEnc> colaboradoresEvtProd) {
        this.colaboradoresEvtProd = colaboradoresEvtProd;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SUBDIVISAO_OS_PROD", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_SUB"))
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE})
    public SubdivisaoOSProdSobEnc getSubdivisaoOSProdSobEnc() {
        return this.subdivisaoOSProdSobEnc;
    }

    public void setSubdivisaoOSProdSobEnc(SubdivisaoOSProdSobEnc subdivisaoOSProd) {
        this.subdivisaoOSProdSobEnc = subdivisaoOSProd;
    }

    @OneToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMUNICADO_PROD", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_COM_PROD"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ComunicadoProducao getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    public void setComunicadoProducao(ComunicadoProducao comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    @OneToMany(mappedBy="evtOsSobEncomenda", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemCompCustoEvtEnc> getItemCompCustoEvtEnc() {
        return this.itemCompCustoEvtEnc;
    }

    public void setItemCompCustoEvtEnc(List<ItemCompCustoEvtEnc> itemCompCustoEvtEnc) {
        this.itemCompCustoEvtEnc = itemCompCustoEvtEnc;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="eventoOsSobEncomenda", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<FichaTecEvtOSSobEncomenda> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecEvtOSSobEncomenda> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @Column(name="TIPO_APONT_EVENTO")
    public Short getTipoApontEvento() {
        return this.tipoApontEvento;
    }

    public void setTipoApontEvento(Short tipoApontEvento) {
        this.tipoApontEvento = tipoApontEvento;
    }

    @OneToMany(mappedBy="eventoOSProdSobEnc", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ItemEventoOsProdSobEnc> getItemEventoOsProdSobEnc() {
        return this.itemEventoOsProdSobEnc;
    }

    public void setItemEventoOsProdSobEnc(List<ItemEventoOsProdSobEnc> itemEventoOsProdSobEnc) {
        this.itemEventoOsProdSobEnc = itemEventoOsProdSobEnc;
    }

    @Column(name="FECHAR_SUB_OS")
    public Short getFecharSubOS() {
        return this.fecharSubOS;
    }

    public void setFecharSubOS(Short fecharSubOS) {
        this.fecharSubOS = fecharSubOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TURNO_TRABALHO", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_SOB_ENC_TURN_TRA"))
    public TurnoDeTrabalho getTurnoDeTrabalho() {
        return this.turnoDeTrabalho;
    }

    public void setTurnoDeTrabalho(TurnoDeTrabalho turnoDeTrabalho) {
        this.turnoDeTrabalho = turnoDeTrabalho;
    }

    @Column(name="CODIGO_BARRAS", length=12)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @OneToMany(mappedBy="eventoOSProd", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<EvtOSSobEncomendaEquip> getEquipamentos() {
        return this.equipamentos;
    }

    public void setEquipamentos(List<EvtOSSobEncomendaEquip> equipamentos) {
        this.equipamentos = equipamentos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_EVT_OS_PCP")
    public ClassificacaoEvtOsPCP getClassificacaoEvento() {
        return this.classificacaoEvento;
    }

    public void setClassificacaoEvento(ClassificacaoEvtOsPCP classificacaoEvento) {
        this.classificacaoEvento = classificacaoEvento;
    }

    @Column(name="ORIGEM_EVENTO")
    public Short getOrigemEvento() {
        return this.origemEvento;
    }

    public void setOrigemEvento(Short origemEvento) {
        this.origemEvento = origemEvento;
    }
}

