/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoRotinaPeriodica;
import com.touchcomp.basementor.model.vo.EsocProcedimentosDiagnosticos;
import com.touchcomp.basementor.model.vo.ItemControleExamesFuncao;
import com.touchcomp.basementor.model.vo.ItemControleExamesPessoas;
import com.touchcomp.basementor.model.vo.ItemControleExamesVeiculos;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EXAME_PERIODICO")
public class ExamePeriodo
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Integer qtdadeDias = 0;
    private List<ItemControleExamesFuncao> funcoes = new ArrayList<ItemControleExamesFuncao>();
    private List<ItemControleExamesPessoas> pessoas = new ArrayList<ItemControleExamesPessoas>();
    private List<ItemControleExamesVeiculos> veiculos = new ArrayList<ItemControleExamesVeiculos>();
    private ClassificacaoRotinaPeriodica classificacao;
    private EsocProcedimentosDiagnosticos esocProcedimentosDiagnosticos;
    private Long nrOcorrencia = 0L;
    private Date tempoDuracao;

    @Id
    @Column(nullable=false, unique=true, name="ID_EXAME_PERIODICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EXAME_PERIODICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=50)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="QTDADE_DIAS")
    public Integer getQtdadeDias() {
        return this.qtdadeDias;
    }

    public void setQtdadeDias(Integer qtdadeDias) {
        this.qtdadeDias = qtdadeDias;
    }

    @OneToMany(mappedBy="rotinaPeriodica", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemControleExamesFuncao> getFuncoes() {
        return this.funcoes;
    }

    public void setFuncoes(List<ItemControleExamesFuncao> funcoes) {
        this.funcoes = funcoes;
    }

    @OneToMany(mappedBy="rotinaPeriodica", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemControleExamesPessoas> getPessoas() {
        return this.pessoas;
    }

    public void setPessoas(List<ItemControleExamesPessoas> pessoas) {
        this.pessoas = pessoas;
    }

    @OneToMany(mappedBy="examePeriodo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemControleExamesVeiculos> getVeiculos() {
        return this.veiculos;
    }

    public void setVeiculos(List<ItemControleExamesVeiculos> veiculos) {
        this.veiculos = veiculos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_ROTINA", foreignKey=@ForeignKey(name="FK_EXAME_PERIODICO_CLAS_ROTINA"))
    public ClassificacaoRotinaPeriodica getClassificacao() {
        return this.classificacao;
    }

    public void setClassificacao(ClassificacaoRotinaPeriodica classificacao) {
        this.classificacao = classificacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_PROCED_DIAGNOSTICOS", foreignKey=@ForeignKey(name="FK_EXAME_PER_ESOC_PROCED_DIAG"))
    public EsocProcedimentosDiagnosticos getEsocProcedimentosDiagnosticos() {
        return this.esocProcedimentosDiagnosticos;
    }

    public void setEsocProcedimentosDiagnosticos(EsocProcedimentosDiagnosticos esocProcedimentosDiagnosticos) {
        this.esocProcedimentosDiagnosticos = esocProcedimentosDiagnosticos;
    }

    @Column(name="NR_OCORRENCIA")
    public Long getNrOcorrencia() {
        return this.nrOcorrencia;
    }

    public void setNrOcorrencia(Long nrOcorrencia) {
        this.nrOcorrencia = nrOcorrencia;
    }

    @Column(name="TEMPO_DURACAO")
    public Date getTempoDuracao() {
        return this.tempoDuracao;
    }

    public void setTempoDuracao(Date tempoDuracao) {
        this.tempoDuracao = tempoDuracao;
    }
}

