/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="EXCLUSAO_NOTA_PROPRIA")
public class ExclusaoNotaPropria
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String motivo;
    private Long numeroInicial;
    private Long numeroFinal;
    private InutilizacaoNumeracaoNFe inutilizacaoNumNfe;
    private String serie;
    private ModeloDocFiscal modeloDocFiscal;
    private PeriodoEmissaoNFe periodoEmissaoNFe;
    private VersaoNFe versaoNFe;
    private Empresa empresa;
    private Date periodo;

    public ExclusaoNotaPropria() {
        this.numeroFinal = this.numeroInicial = Long.valueOf(0L);
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_EXCLUSAO_NOTA_PROPRIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EXCLUSAO_NOTA_PROPRIA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Column(name="NUMERO_INICIAL")
    public Long getNumeroInicial() {
        return this.numeroInicial;
    }

    public void setNumeroInicial(Long numeroInicial) {
        this.numeroInicial = numeroInicial;
    }

    @Column(name="NUMERO_FINAL")
    public Long getNumeroFinal() {
        return this.numeroFinal;
    }

    public void setNumeroFinal(Long numeroFinal) {
        this.numeroFinal = numeroFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INUTILIZACAO_NUM_NFE", foreignKey=@ForeignKey(name="FK_EXCLUSAO_NOTA_PROPRIA_INUN_N"))
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    public InutilizacaoNumeracaoNFe getInutilizacaoNumNfe() {
        return this.inutilizacaoNumNfe;
    }

    public void setInutilizacaoNumNfe(InutilizacaoNumeracaoNFe inutilizacaoNumNfe) {
        this.inutilizacaoNumNfe = inutilizacaoNumNfe;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_EXCLUSAO_NOTA_PROPRIA_MOD_DO"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_EXCLUSAO_NOTA_PROPRIA_PER_EM"))
    public PeriodoEmissaoNFe getPeriodoEmissaoNFe() {
        return this.periodoEmissaoNFe;
    }

    public void setPeriodoEmissaoNFe(PeriodoEmissaoNFe periodoEmissaoNFe) {
        this.periodoEmissaoNFe = periodoEmissaoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VERSAO_NFE", foreignKey=@ForeignKey(name="FK_EXCLUSAO_NOTA_PROPRIA_VER_NF"))
    public VersaoNFe getVersaoNFe() {
        return this.versaoNFe;
    }

    public void setVersaoNFe(VersaoNFe versaoNFe) {
        this.versaoNFe = versaoNFe;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EXCLUSAO_NOTA_PROPRIA_EMPRES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

