/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FabricanteFornecedor;
import com.touchcomp.basementor.model.vo.GrupoFabricantesRelFab;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="FABRICANTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_FABRICANTE", columnNames={"NOME"})})
public class Fabricante
implements InterfaceVO {
    private Long identificador;
    private Long identificadorECommerce;
    private String nome;
    private String descricaoAdicional;
    private String nomeFantasia;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<FabricanteFornecedor> fornecedores;
    private List<GrupoFabricantesRelFab> grupoFabricantesRel;
    private String codSincronizacao;
    private String resourceURI;

    public Fabricante() {
        this.fornecedores = new LinkedList<FabricanteFornecedor>();
        this.grupoFabricantesRel = new ArrayList<GrupoFabricantesRelFab>();
    }

    public Fabricante(Long id, String n) {
        this.identificador = id;
        this.nome = n;
        this.fornecedores = new LinkedList<FabricanteFornecedor>();
        this.grupoFabricantesRel = new ArrayList<GrupoFabricantesRelFab>();
    }

    @Id
    @Column(nullable=false, name="ID_FABRICANTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FABRICANTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=100)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FABRICANTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Ignore
    @Column(name="ID_E_COMMERCE")
    public Long getIdentificadorECommerce() {
        return this.identificadorECommerce;
    }

    @OneToMany(mappedBy="fabricante", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<FabricanteFornecedor> getFornecedores() {
        return this.fornecedores;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long idFabricante) {
        this.identificador = idFabricante;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setIdentificadorECommerce(Long identificadorECommerce) {
        this.identificadorECommerce = identificadorECommerce;
    }

    public void setFornecedores(List<FabricanteFornecedor> fornecedores) {
        this.fornecedores = fornecedores;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="fabricante")
    public List<GrupoFabricantesRelFab> getGrupoFabricantesRel() {
        return this.grupoFabricantesRel;
    }

    public void setGrupoFabricantesRel(List<GrupoFabricantesRelFab> grupoFabricantesRel) {
        this.grupoFabricantesRel = grupoFabricantesRel;
    }

    @Column(name="COD_SINCRONIZACAO", length=30)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }

    @Column(name="RESOURCE_URI")
    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    @Column(name="DESCRICAO_ADICIONAL")
    public String getDescricaoAdicional() {
        return this.descricaoAdicional;
    }

    public void setDescricaoAdicional(String descricaoAdicional) {
        this.descricaoAdicional = descricaoAdicional;
    }

    @Column(name="NOME_FANTASIA")
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }
}

