/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.FaseProdutivaEquip;
import com.touchcomp.basementor.model.vo.FaseProdutivaTpRecurso;
import com.touchcomp.basementor.model.vo.GrupoFuncoesProdutivasFormulacoes;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="FASE_PRODUTIVA")
public class FaseProdutiva
implements InterfaceVO {
    private Long identificador;
    private Short numeroOrdem = 1;
    private CelulaProdutiva celulaProdutiva;
    private Double qtdePorHora = 0.0;
    private Double tempoIntervaloDescanso = 0.0;
    private Double eficienciaEsperada = 0.0;
    private RoteiroProducao roteiroProducao;
    private String descricaoAuxiliar;
    private List<FaseProdutivaEquip> equipamentos = new ArrayList<FaseProdutivaEquip>();
    private List<FaseProdutivaTpRecurso> recursos = new ArrayList<FaseProdutivaTpRecurso>();
    private List<GrupoFuncoesProdutivasFormulacoes> grupoFuncoes = new ArrayList<GrupoFuncoesProdutivasFormulacoes>();
    private Short ativo = 1;
    private Double qtdePorHoraPorUnidade = 0.0;

    @Id
    @Column(nullable=false, name="ID_FASE_PRODUTIVA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FASE_PRODUTIVA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CELULA_PRODUTIVA", foreignKey=@ForeignKey(name="FK_FASE_PRODUTIVA_CEL_PROD"))
    public CelulaProdutiva getCelulaProdutiva() {
        return this.celulaProdutiva;
    }

    public void setCelulaProdutiva(CelulaProdutiva celulaProdutiva) {
        this.celulaProdutiva = celulaProdutiva;
    }

    @Column(nullable=false, name="QTDE_POR_HORA", precision=15, scale=10)
    public Double getQtdePorHora() {
        return this.qtdePorHora;
    }

    public void setQtdePorHora(Double qtdePorHora) {
        this.qtdePorHora = qtdePorHora;
    }

    @Column(name="NUMERO_ORDEM")
    public Short getNumeroOrdem() {
        return this.numeroOrdem;
    }

    public void setNumeroOrdem(Short numeroOrdem) {
        this.numeroOrdem = numeroOrdem;
    }

    public void setRoteiroProducao(RoteiroProducao vo) {
        this.roteiroProducao = vo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTEIRO_PRODUCAO", foreignKey=@ForeignKey(name="FK_FASE_PRODUTIVA_ROT_PRODUCAO"))
    public RoteiroProducao getRoteiroProducao() {
        return this.roteiroProducao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getDescricaoAuxiliar() != null && this.getDescricaoAuxiliar().trim().length() > 0) {
            return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getCelulaProdutiva(), this.getDescricaoAuxiliar()});
        }
        if (this.getCelulaProdutiva() != null) {
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getCelulaProdutiva()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DESCRICAO_AUXILIAR", length=300)
    public String getDescricaoAuxiliar() {
        return this.descricaoAuxiliar;
    }

    public void setDescricaoAuxiliar(String descricaoAuxiliar) {
        this.descricaoAuxiliar = descricaoAuxiliar;
    }

    @OneToMany(mappedBy="faseProdutiva", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<FaseProdutivaEquip> getEquipamentos() {
        return this.equipamentos;
    }

    public void setEquipamentos(List<FaseProdutivaEquip> equipamentos) {
        this.equipamentos = equipamentos;
    }

    @OneToMany(mappedBy="faseProdutiva", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<FaseProdutivaTpRecurso> getRecursos() {
        return this.recursos;
    }

    public void setRecursos(List<FaseProdutivaTpRecurso> recursos) {
        this.recursos = recursos;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="TEMPO_INTERVALO_DESCANSO", precision=15, scale=2)
    public Double getTempoIntervaloDescanso() {
        return this.tempoIntervaloDescanso;
    }

    public void setTempoIntervaloDescanso(Double tempoIntervaloDescanso) {
        this.tempoIntervaloDescanso = tempoIntervaloDescanso;
    }

    @OneToMany(mappedBy="faseProdutiva", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<GrupoFuncoesProdutivasFormulacoes> getGrupoFuncoes() {
        return this.grupoFuncoes;
    }

    public void setGrupoFuncoes(List<GrupoFuncoesProdutivasFormulacoes> grupoFuncoes) {
        this.grupoFuncoes = grupoFuncoes;
    }

    @Column(name="EFICIENCIA_ESPERADA", precision=15, scale=2)
    public Double getEficienciaEsperada() {
        return this.eficienciaEsperada;
    }

    public void setEficienciaEsperada(Double eficienciaEsperada) {
        this.eficienciaEsperada = eficienciaEsperada;
    }

    @Column(name=" QTDE_POR_HORA_POR_UNIDADE", precision=15, scale=6)
    public Double getQtdePorHoraPorUnidade() {
        return this.qtdePorHoraPorUnidade;
    }

    public void setQtdePorHoraPorUnidade(Double qtdePorHoraPorUnidade) {
        this.qtdePorHoraPorUnidade = qtdePorHoraPorUnidade;
    }
}

