/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaTituloNF;
import com.touchcomp.basementor.model.vo.GrupoFaturaTitulos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="FATURA_TITULO")
public class FaturaTitulos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Pessoa pessoa;
    private PlanoConta planoConta;
    private Short pagRec = 1;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private List<FaturaTituloNF> faturaTituloNF = new ArrayList<FaturaTituloNF>();
    private Date dataFatura;
    private Date dataInicial;
    private Date dataFinal;
    private GrupoFaturaTitulos grupoFaturaTitulos;

    @Id
    @Column(nullable=false, name="ID_FATURA_TITULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FATURA_TITULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FATURA_TITULO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="faturaTitulos")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FATURA_TITULO_COND_PAG"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @OneToMany(mappedBy="faturaTitulos")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<FaturaTituloNF> getFaturaTituloNF() {
        return this.faturaTituloNF;
    }

    public void setFaturaTituloNF(List<FaturaTituloNF> faturaTituloNF) {
        this.faturaTituloNF = faturaTituloNF;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FATURA")
    public Date getDataFatura() {
        return this.dataFatura;
    }

    public void setDataFatura(Date dataFatura) {
        this.dataFatura = dataFatura;
    }

    @JoinColumn(name="ID_GRUPO_FATURA_TITULOS", foreignKey=@ForeignKey(name="FK_FATURA_TITULO_GR_FAT_TITULOS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoFaturaTitulos getGrupoFaturaTitulos() {
        return this.grupoFaturaTitulos;
    }

    public void setGrupoFaturaTitulos(GrupoFaturaTitulos grupoFaturaTitulos) {
        this.grupoFaturaTitulos = grupoFaturaTitulos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_FATURA_TITULO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_FATURA_TITULO_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }
}

