/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.DespesaViagem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FECHAM_ADIANTAMENTO_VIAGEM")
public class FechamAdiantamentoViagem
implements InterfaceVO {
    private Long identificador;
    private AdiantamentoViagem adiantamentoViagem;
    private DespesaViagem despesaViagem;
    private Double vrDespesa = 0.0;
    private LancamentoCtbGerencial lancamentoCtbGerencial;
    private Date dataFechamento;
    private String fornecedor;
    private String nrDocumento;
    private CentroCusto centroCusto;

    @Id
    @Column(nullable=false, name="ID_FECHAM_ADIANTAMENTO_VIAGEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FECHAM_ADIANTAMENTO_VIAGEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    @JoinColumn(name="ID_ADIANTAMENTO_VIAGEM", foreignKey=@ForeignKey(name="FK_FECHAM_ADI_VIAGEM_AD_VIAGEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public AdiantamentoViagem getAdiantamentoViagem() {
        return this.adiantamentoViagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DESPESA_VIAGEM", foreignKey=@ForeignKey(name="FK_FECHAM_ADI_VIAGEM_DESP_VIAGE"))
    public DespesaViagem getDespesaViagem() {
        return this.despesaViagem;
    }

    @Column(nullable=false, name="VR_DESPESA", precision=15, scale=2)
    public Double getVrDespesa() {
        return this.vrDespesa;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setAdiantamentoViagem(AdiantamentoViagem adiantamentoViagem) {
        this.adiantamentoViagem = adiantamentoViagem;
    }

    public void setDespesaViagem(DespesaViagem despesaViagem) {
        this.despesaViagem = despesaViagem;
    }

    public void setVrDespesa(Double vrDespesa) {
        this.vrDespesa = vrDespesa;
    }

    @OneToOne(targetEntity=LancamentoCtbGerencial.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LANCAMENTO_CTB_GERENCIAL", foreignKey=@ForeignKey(name="FK_FECHAM_ADI_VIAGEM_LANC_CTB_G"))
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Column(name="FORNECEDOR", length=100)
    public String getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(String fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Column(name="NR_DOCUMENTO", length=20)
    public String getNrDocumento() {
        return this.nrDocumento;
    }

    public void setNrDocumento(String nrDocumento) {
        this.nrDocumento = nrDocumento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - Documento: {1}", (Object[])new Object[]{this.getIdentificador(), this.getNrDocumento()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_centro_custo")
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }
}

