/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdAtMan;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamOrdemServicoColeta;
import com.touchcomp.basementor.model.vo.HoraParadaRetornoAtivo;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FECHAMENTO_ORDEM_SERVICO", uniqueConstraints={@UniqueConstraint(name="UNQ1_FECHAMENTO_ORDEM_SERVICO", columnNames={"ID_ORDEM_SERVICO"})})
public class FechamentoOrdemServico
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short osFechada = 0;
    private OrdemServico ordemServico;
    private List<ServicoProcedimento> servicoProcedimentos = new ArrayList<ServicoProcedimento>();
    private List<Executante> executantes = new ArrayList<Executante>();
    private Double vlrCustoTotal = 0.0;
    private Date dataFechamento;
    private AnaliseCustoCelProdAtMan analiseCustoCelProdAtMan;
    private List<HoraParadaRetornoAtivo> horaParadaRetornoAtivo = new ArrayList<HoraParadaRetornoAtivo>();
    private FechamentoOrdemServico fechamentoOrigem;
    private FechamentoOrdemServico fechamentoGerado;
    private String observacao;
    private ConsumoAtivo consumoAtivo;
    private List<FechamOrdemServicoColeta> fechamOrdemServicoColeta = new ArrayList<FechamOrdemServicoColeta>();

    @Id
    @Column(nullable=false, name="ID_FECHAMENTO_ORDEM_SERVICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FECHAMENTO_ORDEM_SERVICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FECHAMENTO_O_S_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="OS_FECHADO")
    public Short getOsFechada() {
        return this.osFechada;
    }

    public void setOsFechada(Short osFechada) {
        this.osFechada = osFechada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_FECHAMENTO_O_S_OS"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @OneToMany(mappedBy="fechamentoOrdemServico", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ServicoProcedimento> getServicoProcedimentos() {
        return this.servicoProcedimentos;
    }

    public void setServicoProcedimentos(List<ServicoProcedimento> servicoProcedimentos) {
        this.servicoProcedimentos = servicoProcedimentos;
    }

    @OneToMany(mappedBy="fechamentoOrdemServico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Executante> getExecutantes() {
        return this.executantes;
    }

    public void setExecutantes(List<Executante> executantes) {
        this.executantes = executantes;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAMENTO_ORIGEM", foreignKey=@ForeignKey(name="FK_FECHAMENTO_O_S_FECH_ORIGEM"))
    public FechamentoOrdemServico getFechamentoOrigem() {
        return this.fechamentoOrigem;
    }

    public void setFechamentoOrigem(FechamentoOrdemServico fechamentoOrigem) {
        this.fechamentoOrigem = fechamentoOrigem;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getOrdemServico()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VLR_CUSTO_TOTAL", precision=15, scale=2)
    public Double getVlrCustoTotal() {
        return this.vlrCustoTotal;
    }

    public void setVlrCustoTotal(Double vlrCustoTotal) {
        this.vlrCustoTotal = vlrCustoTotal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @OneToOne(mappedBy="fechamentoOrdemServico")
    public AnaliseCustoCelProdAtMan getAnaliseCustoCelProdAtMan() {
        return this.analiseCustoCelProdAtMan;
    }

    public void setAnaliseCustoCelProdAtMan(AnaliseCustoCelProdAtMan analiseCustoCelProdAtMan) {
        this.analiseCustoCelProdAtMan = analiseCustoCelProdAtMan;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="fechamentoOS")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<HoraParadaRetornoAtivo> getHoraParadaRetornoAtivo() {
        return this.horaParadaRetornoAtivo;
    }

    public void setHoraParadaRetornoAtivo(List<HoraParadaRetornoAtivo> horaParadaRetornoAtivo) {
        this.horaParadaRetornoAtivo = horaParadaRetornoAtivo;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONSUMO_ATIVO", foreignKey=@ForeignKey(name="FK_FECHAMENTO_ORDEM_SERV_CONS_A"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ConsumoAtivo getConsumoAtivo() {
        return this.consumoAtivo;
    }

    public void setConsumoAtivo(ConsumoAtivo consumoAtivo) {
        this.consumoAtivo = consumoAtivo;
    }

    @OneToMany(mappedBy="fechamentoOrdemServico", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FechamOrdemServicoColeta> getFechamOrdemServicoColeta() {
        return this.fechamOrdemServicoColeta;
    }

    public void setFechamOrdemServicoColeta(List<FechamOrdemServicoColeta> fechamOrdemServicoColeta) {
        this.fechamOrdemServicoColeta = fechamOrdemServicoColeta;
    }

    @OneToOne(mappedBy="fechamentoOrigem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public FechamentoOrdemServico getFechamentoGerado() {
        return this.fechamentoGerado;
    }

    public void setFechamentoGerado(FechamentoOrdemServico fechamentoGerado) {
        this.fechamentoGerado = fechamentoGerado;
    }
}

