/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.BaseInssEscalonada;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.FeriasQuitacaoUmTerco;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.Media13oSalarioColaborador;
import com.touchcomp.basementor.model.vo.MediaFeriasColaborador;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementor.model.vo.PeriodoFerias;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoFerias;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="FERIAS_COLABORADOR")
public class FeriasColaborador
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date dataGozoInicial;
    private Date dataGozoFinal;
    private Date dataAbonoPecInicial;
    private Date dataAbonoPecFinal;
    private Date dataPagamento;
    private Date dataAviso;
    private Short pgtAdiant13Sal = 0;
    private Long numeroAvos = 0L;
    private Short pgtFeriasDobro = 0;
    private PeriodoAqFeriasColab periodoAqFeriasColab;
    private List<ItemMovimentoFerias> itemMovimentoFerias;
    private PeriodoFerias periodoFerias;
    private List<MediaFeriasColaborador> mediaFeriasColaborador;
    private List<Media13oSalarioColaborador> media13ferias;
    private Double maiorSalario = 0.0;
    private TipoFerias tipoFerias;
    private Long diasFaltosos = 0L;
    private Double diasGozoFerias = 0.0;
    private Double diasDireitoFerias = 0.0;
    private Double diasJaGozadosFerias = 0.0;
    private Double bcIrrfFerias = 0.0;
    private Double vrIrrfFerias = 0.0;
    private Double aliqIrrfFerias = 0.0;
    private Double bcInssFerias = 0.0;
    private Double vrInssFerias = 0.0;
    private Double aliqInssFerias = 0.0;
    private Double bcFgtsFerias = 0.0;
    private Double vrFgtsFerias = 0.0;
    private Double aliqFgtsFerias = 0.0;
    private Double vrLiquidoFerias = 0.0;
    private Double totalDescontos = 0.0;
    private Double totalProventos = 0.0;
    private Short nrDepIrrf = 0;
    private Integer nrReciboFerias = 0;
    private String valorFeriasPorExtenso;
    private Double salarioNominal = 0.0;
    private Date diasGozoFeriasSeguinte;
    private Date diasGozoFeriasSeguinteFinal;
    private Date dataRetorno;
    private Date dataAvisoAbono;
    private Double diaslicencaRemunerada = 0.0;
    private Double vlrLiquidoAddDec = 0.0;
    private Double avosDec = 0.0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private List<RubricasFerias> rubricasFerias;
    private List<BaseInssEscalonada> baseInssEscalonada;
    private Short inssProvisionadoComSalario = 0;
    private Short descartarUmTercoFerias = 0;
    private Short alterarDatas = 0;
    private FeriasQuitacaoUmTerco quitacao;
    private CentroCusto centroCusto;
    private ItemOutrosTitulosFolha outrosTitulosFolha;

    public FeriasColaborador() {
        this.itemMovimentoFerias = new ArrayList<ItemMovimentoFerias>();
        this.mediaFeriasColaborador = new ArrayList<MediaFeriasColaborador>();
        this.rubricasFerias = new ArrayList<RubricasFerias>();
        this.media13ferias = new ArrayList<Media13oSalarioColaborador>();
        this.baseInssEscalonada = new ArrayList<BaseInssEscalonada>();
    }

    @Id
    @Column(name="ID_FERIAS_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FERIAS_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ABONO_PEC_FINAL")
    public Date getDataAbonoPecFinal() {
        return this.dataAbonoPecFinal;
    }

    public void setDataAbonoPecFinal(Date dataAbonoPecFinal) {
        this.dataAbonoPecFinal = dataAbonoPecFinal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ABONO_PEC_INICIAL")
    public Date getDataAbonoPecInicial() {
        return this.dataAbonoPecInicial;
    }

    public void setDataAbonoPecInicial(Date dataAbonoPecInicial) {
        this.dataAbonoPecInicial = dataAbonoPecInicial;
    }

    @Column(name="DATA_AVISO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAviso() {
        return this.dataAviso;
    }

    public void setDataAviso(Date dataAviso) {
        this.dataAviso = dataAviso;
    }

    @Column(name="DATA_GOZO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataGozoFinal() {
        return this.dataGozoFinal;
    }

    public void setDataGozoFinal(Date dataGozoFinal) {
        this.dataGozoFinal = dataGozoFinal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_GOZO_INICIAL")
    public Date getDataGozoInicial() {
        return this.dataGozoInicial;
    }

    public void setDataGozoInicial(Date dataGozoInicial) {
        this.dataGozoInicial = dataGozoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="NUMERO_AVOS")
    public Long getNumeroAvos() {
        return this.numeroAvos;
    }

    public void setNumeroAvos(Long numeroAvos) {
        this.numeroAvos = numeroAvos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_PERIODO_AQ_FERIAS", foreignKey=@ForeignKey(name="FK_FERIAS_COLAB_PER_Q_FERIAS"))
    public PeriodoAqFeriasColab getPeriodoAqFeriasColab() {
        return this.periodoAqFeriasColab;
    }

    public void setPeriodoAqFeriasColab(PeriodoAqFeriasColab periodoAqFeriasColab) {
        this.periodoAqFeriasColab = periodoAqFeriasColab;
    }

    @Column(name="PGT_ADIANT_13_SAL")
    public Short getPgtAdiant13Sal() {
        return this.pgtAdiant13Sal;
    }

    public void setPgtAdiant13Sal(Short pgtAdiant13Sal) {
        this.pgtAdiant13Sal = pgtAdiant13Sal;
    }

    @Column(name="PGT_FERIAS_DOBRO")
    public Short getPgtFeriasDobro() {
        return this.pgtFeriasDobro;
    }

    public void setPgtFeriasDobro(Short pgtFeriasDobro) {
        this.pgtFeriasDobro = pgtFeriasDobro;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ferias", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemMovimentoFerias> getItemMovimentoFerias() {
        return this.itemMovimentoFerias;
    }

    public void setItemMovimentoFerias(List<ItemMovimentoFerias> itemMovimentoFerias) {
        this.itemMovimentoFerias = itemMovimentoFerias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_FERIAS", foreignKey=@ForeignKey(name="FK_FERIAS_COLAB_PER_FERIAS"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public PeriodoFerias getPeriodoFerias() {
        return this.periodoFerias;
    }

    public void setPeriodoFerias(PeriodoFerias periodoFerias) {
        this.periodoFerias = periodoFerias;
    }

    @OneToMany(mappedBy="feriasColaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MediaFeriasColaborador> getMediaFeriasColaborador() {
        return this.mediaFeriasColaborador;
    }

    public void setMediaFeriasColaborador(List<MediaFeriasColaborador> mediaFeriasColaborador) {
        this.mediaFeriasColaborador = mediaFeriasColaborador;
    }

    @OneToMany(mappedBy="feriasColaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Media13oSalarioColaborador> getMedia13ferias() {
        return this.media13ferias;
    }

    public void setMedia13ferias(List<Media13oSalarioColaborador> media13ferias) {
        this.media13ferias = media13ferias;
    }

    @Column(nullable=false, name="VALOR_MAIOR_SALARIO_FERIAS", precision=15, scale=2)
    public Double getMaiorSalario() {
        return this.maiorSalario;
    }

    public void setMaiorSalario(Double maiorSalario) {
        this.maiorSalario = maiorSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FERIAS", foreignKey=@ForeignKey(name="FK_FERIAS_COLAB_TP_FERIAS"))
    public TipoFerias getTipoFerias() {
        return this.tipoFerias;
    }

    public void setTipoFerias(TipoFerias tipoFerias) {
        this.tipoFerias = tipoFerias;
    }

    @Column(name="DIAS_DE_DIREITO_FERIAS", precision=15, scale=4)
    public Double getDiasDireitoFerias() {
        return this.diasDireitoFerias;
    }

    public void setDiasDireitoFerias(Double diasDireitoFerias) {
        this.diasDireitoFerias = diasDireitoFerias;
    }

    @Column(name="DIAS_JA_GOZADOS_FERIAS", precision=15, scale=4)
    public Double getDiasJaGozadosFerias() {
        return this.diasJaGozadosFerias;
    }

    public void setDiasJaGozadosFerias(Double diasJaGozadosFerias) {
        this.diasJaGozadosFerias = diasJaGozadosFerias;
    }

    @Column(name="DIAS_FALTOSOS")
    public Long getDiasFaltosos() {
        return this.diasFaltosos;
    }

    public void setDiasFaltosos(Long diasFaltosos) {
        this.diasFaltosos = diasFaltosos;
    }

    @Column(name="DIAS_DE_GOZO_FERIAS", precision=15, scale=4)
    public Double getDiasGozoFerias() {
        return this.diasGozoFerias;
    }

    public void setDiasGozoFerias(Double diasGozoFerias) {
        this.diasGozoFerias = diasGozoFerias;
    }

    @Column(nullable=false, name="BC_IRRF_FERIAS", precision=15, scale=4)
    public Double getBcIrrfFerias() {
        this.bcIrrfFerias = this.bcIrrfFerias == null ? 0.0 : this.bcIrrfFerias;
        return this.bcIrrfFerias;
    }

    public void setBcIrrfFerias(Double bcIrrfFerias) {
        this.bcIrrfFerias = bcIrrfFerias = Double.valueOf(bcIrrfFerias == null ? 0.0 : bcIrrfFerias);
    }

    @Column(name="VR_IRRF_FERIAS", precision=15, scale=4)
    public Double getVrIrrfFerias() {
        this.vrIrrfFerias = this.vrIrrfFerias == null ? 0.0 : this.vrIrrfFerias;
        return this.vrIrrfFerias;
    }

    public void setVrIrrfFerias(Double vrIrrfFerias) {
        this.vrIrrfFerias = vrIrrfFerias = Double.valueOf(vrIrrfFerias == null ? 0.0 : vrIrrfFerias);
    }

    @Column(name="ALIQ_IRRF_FERIAS", precision=15, scale=4)
    public Double getAliqIrrfFerias() {
        this.aliqIrrfFerias = this.aliqIrrfFerias == null ? 0.0 : this.aliqIrrfFerias;
        return this.aliqIrrfFerias;
    }

    public void setAliqIrrfFerias(Double aliqIrrfFerias) {
        this.aliqIrrfFerias = aliqIrrfFerias = Double.valueOf(aliqIrrfFerias == null ? 0.0 : aliqIrrfFerias);
    }

    @Column(nullable=false, name="BC_INNS_FERIAS", precision=15, scale=4)
    public Double getBcInssFerias() {
        return this.bcInssFerias;
    }

    public void setBcInssFerias(Double bcInssFerias) {
        this.bcInssFerias = bcInssFerias;
    }

    @Column(name="VR_INSS_FERIAS", precision=15, scale=4)
    public Double getVrInssFerias() {
        return this.vrInssFerias;
    }

    public void setVrInssFerias(Double vrInssFerias) {
        this.vrInssFerias = vrInssFerias;
    }

    @Column(name="ALIQ_INSS_FERIAS", precision=15, scale=4)
    public Double getAliqInssFerias() {
        return this.aliqInssFerias;
    }

    public void setAliqInssFerias(Double aliqInssFerias) {
        this.aliqInssFerias = aliqInssFerias;
    }

    @Column(nullable=false, name="BC_FGTS_FERIAS", precision=15, scale=4)
    public Double getBcFgtsFerias() {
        this.bcFgtsFerias = this.bcFgtsFerias == null ? 0.0 : this.bcFgtsFerias;
        return this.bcFgtsFerias;
    }

    public void setBcFgtsFerias(Double bcFgtsFerias) {
        this.bcFgtsFerias = bcFgtsFerias = Double.valueOf(bcFgtsFerias == null ? 0.0 : bcFgtsFerias);
    }

    @Column(nullable=false, name="VR_FGTS_FERIAS", precision=15, scale=4)
    public Double getVrFgtsFerias() {
        this.vrFgtsFerias = this.vrFgtsFerias == null ? 0.0 : this.vrFgtsFerias;
        return this.vrFgtsFerias;
    }

    public void setVrFgtsFerias(Double vrFgtsFerias) {
        this.vrFgtsFerias = vrFgtsFerias = Double.valueOf(vrFgtsFerias == null ? 0.0 : vrFgtsFerias);
    }

    @Column(name="ALIQ_FGTS_FERIAS", precision=15, scale=4)
    public Double getAliqFgtsFerias() {
        this.aliqFgtsFerias = this.aliqFgtsFerias == null ? 0.0 : this.aliqFgtsFerias;
        return this.aliqFgtsFerias;
    }

    public void setAliqFgtsFerias(Double aliqFgtsFerias) {
        this.aliqFgtsFerias = aliqFgtsFerias = Double.valueOf(aliqFgtsFerias == null ? 0.0 : aliqFgtsFerias);
    }

    @Column(name="VR_LIQUIDO_FERIAS", precision=15, scale=4)
    public Double getVrLiquidoFerias() {
        this.vrLiquidoFerias = this.vrLiquidoFerias == null ? 0.0 : this.vrLiquidoFerias;
        return this.vrLiquidoFerias;
    }

    public void setVrLiquidoFerias(Double vrLiquidoFerias) {
        this.vrLiquidoFerias = vrLiquidoFerias = Double.valueOf(vrLiquidoFerias == null ? 0.0 : vrLiquidoFerias);
    }

    @Column(name="TOTAL_DESCONTOS", precision=15, scale=4)
    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public void setTotalDescontos(Double totalDescontos) {
        this.totalDescontos = totalDescontos;
    }

    @Column(name="TOTAL_PROVENTOS", precision=15, scale=4)
    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalProventos) {
        this.totalProventos = totalProventos;
    }

    @Column(name="NR_DEP_IRRF")
    public Short getNrDepIrrf() {
        return this.nrDepIrrf;
    }

    public void setNrDepIrrf(Short nrDepIrrf) {
        this.nrDepIrrf = nrDepIrrf;
    }

    @Column(name="NR_RECIBO_FERIAS")
    @Generated(value=GenerationTime.INSERT)
    public Integer getNrReciboFerias() {
        return this.nrReciboFerias;
    }

    public void setNrReciboFerias(Integer nrReciboFerias) {
        this.nrReciboFerias = nrReciboFerias;
    }

    @Transient
    public String getValorFeriasPorExtenso() {
        return this.valorFeriasPorExtenso;
    }

    public void setValorFeriasPorExtenso(String valorFeriasPorExtenso) {
        this.valorFeriasPorExtenso = valorFeriasPorExtenso;
    }

    @Column(name="SALARIO_NOMINAL", precision=15, scale=2)
    public Double getSalarioNominal() {
        return this.salarioNominal;
    }

    public void setSalarioNominal(Double salarioNominal) {
        this.salarioNominal = salarioNominal;
    }

    @Temporal(value=TemporalType.DATE)
    @Transient
    public Date getDiasGozoFeriasSeguinte() {
        this.diasGozoFeriasSeguinte = ToolDate.nextDays((Date)this.dataGozoInicial, (int)1);
        return this.diasGozoFeriasSeguinte;
    }

    @Temporal(value=TemporalType.DATE)
    @Transient
    public Date getDiasGozoFeriasSeguinteFinal() {
        this.diasGozoFeriasSeguinteFinal = ToolDate.nextDays((Date)this.dataGozoFinal, (int)1);
        return this.diasGozoFeriasSeguinteFinal;
    }

    @Column(name="DATA_RETORNO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @Transient
    @Temporal(value=TemporalType.DATE)
    public Date getDataAvisoAbono() {
        return this.dataAvisoAbono;
    }

    public void setDataAvisoAbono(Date dataAvisoAbono) {
        this.dataAvisoAbono = dataAvisoAbono;
    }

    @Column(name="DIAS_DE_LICENCA_REMUNERADA", precision=15, scale=4)
    public Double getDiaslicencaRemunerada() {
        return this.diaslicencaRemunerada;
    }

    public void setDiaslicencaRemunerada(Double diaslicencaRemunerada) {
        this.diaslicencaRemunerada = diaslicencaRemunerada;
    }

    @Column(name="VLR_LIQUIDO_DEC", precision=15, scale=2)
    public Double getVlrLiquidoAddDec() {
        this.vlrLiquidoAddDec = this.vlrLiquidoAddDec == null ? 0.0 : this.vlrLiquidoAddDec;
        return this.vlrLiquidoAddDec;
    }

    public void setVlrLiquidoAddDec(Double vlrLiquidoAddDec) {
        this.vlrLiquidoAddDec = vlrLiquidoAddDec;
    }

    @Column(nullable=false, name="AVOS_DEC", precision=15, scale=2)
    public Double getAvosDec() {
        return this.avosDec;
    }

    public void setAvosDec(Double avosDec) {
        this.avosDec = avosDec;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPeriodoAqFeriasColab() != null ? this.getPeriodoAqFeriasColab().getColaborador().toString() : this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Override
    @OneToMany(mappedBy="feriasColaborador")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ferias")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RubricasFerias> getRubricasFerias() {
        return this.rubricasFerias;
    }

    public void setRubricasFerias(List<RubricasFerias> rubricasFerias) {
        this.rubricasFerias = rubricasFerias;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ferias", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BaseInssEscalonada> getBaseInssEscalonada() {
        return this.baseInssEscalonada;
    }

    public void setBaseInssEscalonada(List<BaseInssEscalonada> baseInssEscalonada) {
        this.baseInssEscalonada = baseInssEscalonada;
    }

    @Column(name="INSS_PROV_COM_SALARIO")
    public Short getInssProvisionadoComSalario() {
        return this.inssProvisionadoComSalario;
    }

    public void setInssProvisionadoComSalario(Short inssProvisionadoComSalario) {
        this.inssProvisionadoComSalario = inssProvisionadoComSalario;
    }

    @Column(name="DESCARTAR_UM_TERCO")
    public Short getDescartarUmTercoFerias() {
        return this.descartarUmTercoFerias;
    }

    public void setDescartarUmTercoFerias(Short descartarUmTercoFerias) {
        this.descartarUmTercoFerias = descartarUmTercoFerias;
    }

    @Column(name="ALTERAR_DATAS")
    public Short getAlterarDatas() {
        return this.alterarDatas;
    }

    public void setAlterarDatas(Short alterarDatas) {
        this.alterarDatas = alterarDatas;
    }

    @OneToOne(mappedBy="ferias")
    public FeriasQuitacaoUmTerco getQuitacao() {
        return this.quitacao;
    }

    public void setQuitacao(FeriasQuitacaoUmTerco quitacao) {
        this.quitacao = quitacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_FERIAS_COLAB_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }
}

