/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoFormaPagamentoCPFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoPagamento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="FORMAS_PAG_CUPOM_FISCAL")
public class FormasPagCupomFiscal
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Double percDesconto = 0.0;
    private Double percAcrescimo = 0.0;
    private Date dataCadastro;
    private Empresa empresa;
    private Short nrViasCupTEF = 0;
    private Timestamp dataAtualizacao;
    private CondicoesPagamento condicoesPagamento;
    private Double percEncargosFinanceiros = 0.0;
    private PlanoConta planoConta;
    private Long codigoAuxiliar;
    private Pessoa pessoa;
    private Double taxaCartao = 0.0;
    private Integer diasDeslocamento = 0;
    private Short deducaoTaxa = 0;
    private Integer diaFechamento = 0;
    private Integer diaPagamento = 0;
    private Short opcaoPadrao = 0;
    private TipoPagamento tipoPagamento;
    private Short tipoDebito = 0;
    private Short tipoCredito = 0;
    private CarteiraCobranca carteiraCobranca;
    private GrupoFormaPagamentoCPFiscal grupoFormaPagamentoCPFiscal;
    private Short ativo = 1;
    private Short nrParcelas = 0;
    private CentroCusto centroCusto;
    private PlanoContaGerencial planoContaGerencial;
    private Short excluiSabado = 0;
    private Short excluiDomingo = 0;
    private Short excluiFeriado = 0;
    private Short dataFixa = 0;
    private Integer diaFixo = 0;
    private Integer diaVariavel = 0;

    @Id
    @Column(nullable=false, name="ID_FORMAS_PAG_CP_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FORMAS_PAG_CP_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="PERC_DESCONTO", precision=15, scale=2)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double valorDesconto) {
        this.percDesconto = valorDesconto;
    }

    @Column(name="PERC_ACRESCIMO", precision=15, scale=2)
    public Double getPercAcrescimo() {
        return this.percAcrescimo;
    }

    public void setPercAcrescimo(Double valorAcrescimo) {
        this.percAcrescimo = valorAcrescimo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NR_VIAS_CUP_TEF")
    public Short getNrViasCupTEF() {
        return this.nrViasCupTEF;
    }

    public void setNrViasCupTEF(Short nrViasCupTEF) {
        this.nrViasCupTEF = nrViasCupTEF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_CPAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PERC_ENCARGOS_FINANCEIROS", precision=15, scale=2)
    public Double getPercEncargosFinanceiros() {
        return this.percEncargosFinanceiros;
    }

    public void setPercEncargosFinanceiros(Double percEncargosFinanceiros) {
        this.percEncargosFinanceiros = percEncargosFinanceiros;
    }

    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_PC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Column(name="CODIGO_AUXILIAR")
    @Ignore
    public Long getCodigoAuxiliar() {
        return this.codigoAuxiliar;
    }

    public void setCodigoAuxiliar(Long codigoAuxiliar) {
        this.codigoAuxiliar = codigoAuxiliar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_PESS"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(nullable=false, name="TAXA_CARTAO", precision=15, scale=2)
    public Double getTaxaCartao() {
        return this.taxaCartao;
    }

    public void setTaxaCartao(Double taxaCartao) {
        this.taxaCartao = taxaCartao;
    }

    @Column(name="DIAS_DESLOCAMENTO")
    public Integer getDiasDeslocamento() {
        return this.diasDeslocamento;
    }

    public void setDiasDeslocamento(Integer diasDeslocamento) {
        this.diasDeslocamento = diasDeslocamento;
    }

    @Column(name="DEDUCAO_TAXA")
    public Short getDeducaoTaxa() {
        return this.deducaoTaxa;
    }

    public void setDeducaoTaxa(Short deducaoTaxa) {
        this.deducaoTaxa = deducaoTaxa;
    }

    @Column(name="DIA_FECHAMENTO")
    public Integer getDiaFechamento() {
        return this.diaFechamento;
    }

    public void setDiaFechamento(Integer diaFechamento) {
        this.diaFechamento = diaFechamento;
    }

    @Column(name="DIA_PAGAMENTO")
    public Integer getDiaPagamento() {
        return this.diaPagamento;
    }

    public void setDiaPagamento(Integer diaPagamento) {
        this.diaPagamento = diaPagamento;
    }

    @Column(name="OPCAO_PADRAO")
    public Short getOpcaoPadrao() {
        return this.opcaoPadrao;
    }

    public void setOpcaoPadrao(Short opcaoPadrao) {
        this.opcaoPadrao = opcaoPadrao;
    }

    @JoinColumn(name="ID_TIPO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_TP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoPagamento getTipoPagamento() {
        return this.tipoPagamento;
    }

    public void setTipoPagamento(TipoPagamento tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
    }

    @Column(name="TIPO_DEBITO")
    public Short getTipoDebito() {
        return this.tipoDebito;
    }

    public void setTipoDebito(Short tipoDebito) {
        this.tipoDebito = tipoDebito;
    }

    @Column(name="TIPO_CREDITO")
    public Short getTipoCredito() {
        return this.tipoCredito;
    }

    public void setTipoCredito(Short tipoCredito) {
        this.tipoCredito = tipoCredito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_CC"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @JoinColumn(name="ID_GRUPO_FORMA_PAG_CP_FISCAL", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_GR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoFormaPagamentoCPFiscal getGrupoFormaPagamentoCPFiscal() {
        return this.grupoFormaPagamentoCPFiscal;
    }

    public void setGrupoFormaPagamentoCPFiscal(GrupoFormaPagamentoCPFiscal grupoFormaPagamentoCPFiscal) {
        this.grupoFormaPagamentoCPFiscal = grupoFormaPagamentoCPFiscal;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="NR_PARCELAS")
    public Short getNrParcelas() {
        return this.nrParcelas;
    }

    public void setNrParcelas(Short nrParcelas) {
        this.nrParcelas = nrParcelas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_CCU"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_FORMAS_PAG_CUPOM_FISCAL_PC_G"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="EXCLUI_SABADO")
    public Short getExcluiSabado() {
        return this.excluiSabado;
    }

    public void setExcluiSabado(Short excluiSabado) {
        this.excluiSabado = excluiSabado;
    }

    @Column(name="EXCLUI_DOMINGO")
    public Short getExcluiDomingo() {
        return this.excluiDomingo;
    }

    public void setExcluiDomingo(Short excluiDomingo) {
        this.excluiDomingo = excluiDomingo;
    }

    @Column(name="EXCLUI_FERIADO")
    public Short getExcluiFeriado() {
        return this.excluiFeriado;
    }

    public void setExcluiFeriado(Short excluiFeriado) {
        this.excluiFeriado = excluiFeriado;
    }

    @Column(name="DATA_FIXA")
    public Short getDataFixa() {
        return this.dataFixa;
    }

    public void setDataFixa(Short dataFixa) {
        this.dataFixa = dataFixa;
    }

    @Column(name="DIA_FIXO")
    public Integer getDiaFixo() {
        return this.diaFixo;
    }

    public void setDiaFixo(Integer diaFixo) {
        this.diaFixo = diaFixo;
    }

    @Column(name="DIA_VARIAVEL")
    public Integer getDiaVariavel() {
        return this.diaVariavel;
    }

    public void setDiaVariavel(Integer diaVariavel) {
        this.diaVariavel = diaVariavel;
    }
}

