/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.ClassificacaoFornecedor;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocIndicativoContPrevidenciario;
import com.touchcomp.basementor.model.vo.FichaTecFornecedor;
import com.touchcomp.basementor.model.vo.GrupoFornecedoresRelForn;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FORNECEDOR")
public class Fornecedor
implements InterfaceVO {
    private Empresa empresa;
    private Short tipoEpp = 0;
    private String observacao = "";
    private Date dataCadastro;
    private Long identificador;
    private Pessoa pessoa;
    private Short tipo = 0;
    private CategoriaPessoa categoriaPessoa;
    private ClassificacaoClientes classificacaoPessoa;
    private Timestamp dataAtualizacao;
    private List<UnidadeFatFornecedor> unidadesFatForn = new ArrayList<UnidadeFatFornecedor>();
    private CondicoesPagamento condicaoPagamento;
    private List<GrupoFornecedoresRelForn> fornecedores = new ArrayList<GrupoFornecedoresRelForn>();
    private List<FichaTecFornecedor> fichasTecnicas = new ArrayList<FichaTecFornecedor>();
    private EsocIndicativoContPrevidenciario esocIndicativoContPrev;
    private ClassificacaoFornecedor classificacaoFornecedor;
    private Short ativo;

    public Fornecedor() {
        this.ativo = EnumConstantsMentorSimNao.SIM.value;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_FORNECEDOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FORNECEDOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FORNECEDOR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="TIPO_EPP")
    public Short getTipoEpp() {
        return this.tipoEpp;
    }

    @Column(name="OBS", length=200)
    public String getObservacao() {
        return this.observacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_FORNECEDOR_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa idEmp) {
        this.empresa = idEmp;
    }

    public void setTipoEpp(Short tipoEpp) {
        this.tipoEpp = tipoEpp;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_FORNECEDOR_PESSOA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="fornecedor", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<UnidadeFatFornecedor> getUnidadesFatForn() {
        return this.unidadesFatForn;
    }

    public void setUnidadesFatForn(List<UnidadeFatFornecedor> unidadesFatForn) {
        this.unidadesFatForn = unidadesFatForn;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FORNECEDOR_COND_PAG"))
    public CondicoesPagamento getCondicaoPagamento() {
        return this.condicaoPagamento;
    }

    public void setCondicaoPagamento(CondicoesPagamento idCondPg) {
        this.condicaoPagamento = idCondPg;
    }

    @OneToMany(mappedBy="fornecedor")
    public List<GrupoFornecedoresRelForn> getFornecedores() {
        return this.fornecedores;
    }

    public void setFornecedores(List<GrupoFornecedoresRelForn> fornecedores) {
        this.fornecedores = fornecedores;
    }

    @OneToMany(mappedBy="fornecedor", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<FichaTecFornecedor> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecFornecedor> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_IND_CONT_PREV", foreignKey=@ForeignKey(name="FK_ESOC_IND_CONT_FORNECEDOR"))
    public EsocIndicativoContPrevidenciario getEsocIndicativoContPrev() {
        return this.esocIndicativoContPrev;
    }

    public void setEsocIndicativoContPrev(EsocIndicativoContPrevidenciario esocIndicativoContPrev) {
        this.esocIndicativoContPrev = esocIndicativoContPrev;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_FORNECEDOR", foreignKey=@ForeignKey(name="FK_FORNECEDOR_CLAS_FORNECEDOR"))
    public ClassificacaoFornecedor getClassificacaoFornecedor() {
        return this.classificacaoFornecedor;
    }

    public void setClassificacaoFornecedor(ClassificacaoFornecedor classificacaoFornecedor) {
        this.classificacaoFornecedor = classificacaoFornecedor;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_FORNECEDOR_CLAS_PESSOA"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }
}

