/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.Marca;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.MotivoAquisicaoPref;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="FORNECEDOR_ITEM_COTACAO_COMPRA")
public class FornecedorItemCotacaoCompra
implements InterfaceVO {
    private Long identificador;
    private Long prazoEntrega = 0L;
    private Date dataCadastro;
    private Short selecionado = 0;
    private Short habilitarPercentualDesconto = 0;
    private Short habilitarPercentualFrete = 0;
    private Short habilitarPercentualSeguro = 0;
    private Short habilitarPercentualDespesasAcessorias = 0;
    private Short aquisicaoPreferencial = 0;
    private Double percentualFrete = 0.0;
    private Double percentualSeguro = 0.0;
    private Double percentualDesconto = 0.0;
    private Double percentualDespesasAcessorias = 0.0;
    private Double valorFrete = 0.0;
    private Double valorCusto = 0.0;
    private Double valorSeguro = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorUnitario = 0.0;
    private Double valorDespesasAcessorias = 0.0;
    private String condicaoPagamentoMutante;
    private String justficativaAquisicaoPreferencial;
    private TipoFrete tipoFrete;
    private PlanoConta planoConta;
    private ModeloFiscal modeloFiscal;
    private ItemCotacaoCompra itemCotacaoCompra;
    private CondicoesPagamento condicoesPagamento;
    private PlanoContaGerencial planoContaGerencial;
    private UnidadeFatFornecedor unidadeFaturamentoFornecedor;
    private FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal;
    private String observacao;
    private Marca marca;
    private Date dataPrevFaturamento;
    private Double ultimoCusto = 0.0;
    private Double custoMedio = 0.0;
    private Double menorCusto = 0.0;
    private Double valorUnitarioMoeda = 0.0;
    private Moeda moeda;
    private CotacaoMoeda cotacaoMoeda;
    private MotivoAquisicaoPref motivoAquisPref;
    private Short validado = 0;
    private Double valorTotalConvertido = 0.0;
    private LeadTimeFornProduto leadTimeFornProduto;
    private Short dolarNegociado = EnumConstantsMentorSimNao.SIM.getValue();
    private String pessoaContato;

    @Id
    @Column(name="ID_FORN_ITEM_COTACAO_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FORN_ITEM_COTACAO_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="SELECIONADO")
    public Short getSelecionado() {
        return this.selecionado;
    }

    @Column(name="HABILITAR_PERCENTUAL_DESCONTO")
    public Short getHabilitarPercentualDesconto() {
        return this.habilitarPercentualDesconto;
    }

    @Column(name="HABILITAR_PERCENTUAL_FRETE")
    public Short getHabilitarPercentualFrete() {
        return this.habilitarPercentualFrete;
    }

    @Column(name="HABILITAR_PERCENTUAL_SEGURO")
    public Short getHabilitarPercentualSeguro() {
        return this.habilitarPercentualSeguro;
    }

    @Column(name="HABILITAR_PERCENTUAL_DESP_ACESS")
    public Short getHabilitarPercentualDespesasAcessorias() {
        return this.habilitarPercentualDespesasAcessorias;
    }

    @Column(name="AQUISICAO_PREFERENCIAL")
    public Short getAquisicaoPreferencial() {
        return this.aquisicaoPreferencial;
    }

    @Column(name="PERCENTUAL_FRETE", precision=18, scale=6)
    public Double getPercentualFrete() {
        return this.percentualFrete;
    }

    @Column(name="PERCENTUAL_SEGURO", precision=18, scale=6)
    public Double getPercentualSeguro() {
        return this.percentualSeguro;
    }

    @Column(name="PERCENTUAL_DESCONTO", precision=18, scale=6)
    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    @Column(name="PERCENTUAL_DESPESAS_ACESSORIAS", precision=18, scale=6)
    public Double getPercentualDespesasAcessorias() {
        return this.percentualDespesasAcessorias;
    }

    @Column(name="VALOR_FRETE", precision=18, scale=6)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(nullable=false, name="VALOR_CUSTO", precision=18, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @Column(name="VALOR_SEGURO", precision=18, scale=6)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Column(name="VALOR_DESCONTO", precision=18, scale=6)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=18, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @Column(nullable=false, name="VALOR_DESPESAS_ACESSORIAS", precision=18, scale=6)
    public Double getValorDespesasAcessorias() {
        return this.valorDespesasAcessorias;
    }

    @Column(name="CONDICAO_PAGAMENTO_MUTANTE", length=255)
    public String getCondicaoPagamentoMutante() {
        return this.condicaoPagamentoMutante;
    }

    @Column(name="JUSTIFICATIVA_AQUISICAO_PREF", length=255)
    public String getJustficativaAquisicaoPreferencial() {
        return this.justficativaAquisicaoPreferencial;
    }

    @Column(name="PRAZO_ENTREGA")
    public Long getPrazoEntrega() {
        return this.prazoEntrega;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_TF"))
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_MF"))
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_COTACAO_COMPRA", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_ICC"))
    public ItemCotacaoCompra getItemCotacaoCompra() {
        return this.itemCotacaoCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COT_COMP_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_PCG"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FATURAMENTO_FORN", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_UFF"))
    public UnidadeFatFornecedor getUnidadeFaturamentoFornecedor() {
        return this.unidadeFaturamentoFornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORN_ITEM_COTACAO_LIVRO_FISC", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMPRA_LF"))
    @Cascade(value={CascadeType.ALL})
    public FornecedorItemCotacaoCompraLivroFiscal getFornecedorItemCotacaoCompraLivroFiscal() {
        return this.fornecedorItemCotacaoCompraLivroFiscal;
    }

    @Column(name="PESSOA_CONTATO", length=255)
    public String getPessoaContato() {
        return this.pessoaContato;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setSelecionado(Short selecionado) {
        this.selecionado = selecionado;
    }

    public void setHabilitarPercentualDesconto(Short habilitarPercentualDesconto) {
        this.habilitarPercentualDesconto = habilitarPercentualDesconto;
    }

    public void setHabilitarPercentualFrete(Short habilitarPercentualFrete) {
        this.habilitarPercentualFrete = habilitarPercentualFrete;
    }

    public void setHabilitarPercentualSeguro(Short habilitarPercentualSeguro) {
        this.habilitarPercentualSeguro = habilitarPercentualSeguro;
    }

    public void setHabilitarPercentualDespesasAcessorias(Short habilitarPercentualDespesasAcessorias) {
        this.habilitarPercentualDespesasAcessorias = habilitarPercentualDespesasAcessorias;
    }

    public void setAquisicaoPreferencial(Short aquisicaoPreferencial) {
        this.aquisicaoPreferencial = aquisicaoPreferencial;
    }

    public void setPercentualFrete(Double percentualFrete) {
        this.percentualFrete = percentualFrete;
    }

    public void setPercentualSeguro(Double percentualSeguro) {
        this.percentualSeguro = percentualSeguro;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    public void setPercentualDespesasAcessorias(Double percentualDespesasAcessorias) {
        this.percentualDespesasAcessorias = percentualDespesasAcessorias;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setValorDespesasAcessorias(Double valorDespesasAcessorias) {
        this.valorDespesasAcessorias = valorDespesasAcessorias;
    }

    public void setCondicaoPagamentoMutante(String condicaoPagamentoMutante) {
        this.condicaoPagamentoMutante = condicaoPagamentoMutante;
    }

    public void setJustficativaAquisicaoPreferencial(String justficativaAquisicaoPreferencial) {
        this.justficativaAquisicaoPreferencial = justficativaAquisicaoPreferencial;
    }

    public void setPrazoEntrega(Long prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    public void setItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra) {
        this.itemCotacaoCompra = itemCotacaoCompra;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    public void setUnidadeFaturamentoFornecedor(UnidadeFatFornecedor unidadeFaturamentoFornecedor) {
        this.unidadeFaturamentoFornecedor = unidadeFaturamentoFornecedor;
    }

    public void setFornecedorItemCotacaoCompraLivroFiscal(FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal) {
        this.fornecedorItemCotacaoCompraLivroFiscal = fornecedorItemCotacaoCompraLivroFiscal;
    }

    public void setPessoaContato(String pessoaContato) {
        this.pessoaContato = pessoaContato;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getUnidadeFaturamentoFornecedor() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getUnidadeFaturamentoFornecedor().getFornecedor().getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=1500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @JoinColumn(name="ID_MARCA", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COTACAO_COMP_MARCA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Marca getMarca() {
        return this.marca;
    }

    public void setMarca(Marca marca) {
        this.marca = marca;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREV_FATURAMENTO")
    public Date getDataPrevFaturamento() {
        return this.dataPrevFaturamento;
    }

    public void setDataPrevFaturamento(Date dataPrevFaturamento) {
        this.dataPrevFaturamento = dataPrevFaturamento;
    }

    @Column(name="ULTIMO_CUSTO")
    public Double getUltimoCusto() {
        return this.ultimoCusto;
    }

    public void setUltimoCusto(Double ultimoCusto) {
        this.ultimoCusto = ultimoCusto;
    }

    @Column(name="CUSTO_MEDIO")
    public Double getCustoMedio() {
        return this.custoMedio;
    }

    public void setCustoMedio(Double custoMedio) {
        this.custoMedio = custoMedio;
    }

    @Column(name="MENOR_CUSTO")
    public Double getMenorCusto() {
        return this.menorCusto;
    }

    public void setMenorCusto(Double menorCusto) {
        this.menorCusto = menorCusto;
    }

    @Column(name="VALOR_UNITARIO_MOEDA", precision=18, scale=6)
    public Double getValorUnitarioMoeda() {
        return this.valorUnitarioMoeda;
    }

    public void setValorUnitarioMoeda(Double valorUnitarioMoeda) {
        this.valorUnitarioMoeda = valorUnitarioMoeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COT_COMP_MOEDA"))
    public Moeda getMoeda() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COT_COMP_COT_MOED"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_AQUISICAO_PREF", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COT_COMP_MOT_AQ_PR"))
    public MotivoAquisicaoPref getMotivoAquisPref() {
        return this.motivoAquisPref;
    }

    public void setMotivoAquisPref(MotivoAquisicaoPref motivoAquisPref) {
        this.motivoAquisPref = motivoAquisPref;
    }

    @Column(name="VALIDADO")
    public Short getValidado() {
        return this.validado;
    }

    public void setValidado(Short validado) {
        this.validado = validado;
    }

    @Column(name="VALOR_TOTAL_CONVERTIDO")
    public Double getValorTotalConvertido() {
        return this.valorTotalConvertido;
    }

    public void setValorTotalConvertido(Double valorTotalConvertido) {
        this.valorTotalConvertido = valorTotalConvertido;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LEAD_TIME_FORN_PRODUTO", foreignKey=@ForeignKey(name="FK_FORN_ITEM_ID_LEAD_TIME_F_P"))
    public LeadTimeFornProduto getLeadTimeFornProduto() {
        return this.leadTimeFornProduto;
    }

    public void setLeadTimeFornProduto(LeadTimeFornProduto leadTimeFornProduto) {
        this.leadTimeFornProduto = leadTimeFornProduto;
    }

    @Column(name="DOLAR_CONFIRMADO")
    public Short getDolarNegociado() {
        return this.dolarNegociado;
    }

    public void setDolarNegociado(Short dolarNegociado) {
        this.dolarNegociado = dolarNegociado;
    }
}

