/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FreteCombPagtoTranspAgregado;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="FRETE_COMB_TRANSP_AGREG")
public class FreteCombTranspAgreg
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataLancamento;
    private ConjuntoTransportador conjuntoTransportador;
    private TransportadorAgregado transportadorAgregado;
    private Cte cte;
    private Rps rps;
    private Double valorFrete = 0.0;
    private String observacao;
    private Short tipoOrigemFrete = 0;
    private FreteCombPagtoTranspAgregado freteCombPagtoAgregado;

    @Id
    @Column(name="ID_FRETE_COMB_TRANSP_AGREG")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FRETE_COMB_TRANSP_AGREG")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FRETE_COMB_TRANSP_AGREG_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_LANCAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @JoinColumn(name="ID_TRANSPORTADOR_AGREGADO", foreignKey=@ForeignKey(name="FK_FRETE_COMB_TRANSP_AGREG_TRAN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_FRETE_COMB_TRANSP_AGREG_CTE"))
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RPS", foreignKey=@ForeignKey(name="FK_FRETE_COMB_TRANSP_AGREG_RPS"))
    public Rps getRps() {
        return this.rps;
    }

    public void setRps(Rps rps) {
        this.rps = rps;
    }

    @Column(name="OBSERVACAO", length=200)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(name="TIPO_ORIGEM_FRETE")
    public Short getTipoOrigemFrete() {
        return this.tipoOrigemFrete;
    }

    public void setTipoOrigemFrete(Short tipoOrigemFrete) {
        this.tipoOrigemFrete = tipoOrigemFrete;
    }

    @OneToOne(mappedBy="freteComTranspAgreg", fetch=FetchType.LAZY)
    public FreteCombPagtoTranspAgregado getFreteCombPagtoAgregado() {
        return this.freteCombPagtoAgregado;
    }

    public void setFreteCombPagtoAgregado(FreteCombPagtoTranspAgregado freteCombPagtoAgregado) {
        this.freteCombPagtoAgregado = freteCombPagtoAgregado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_FRETE_COMB_TRANSP_AGREG_CT"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

