/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Cbo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="FUNCAO")
public class Funcao
implements InterfaceVO,
InterfaceVOEsocial {
    private String descricao;
    private Empresa empresa;
    private Date dataCadastro;
    private Long identificador;
    private Cbo cbo;
    private Timestamp dataAtualizacao;
    private Double valorReferenciaHora = 0.0;
    private Short ativo = 1;
    private String codigoCargo;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Date dataInicio;
    private Short informarCodigoEsocial = 0;
    private CentroCusto centroCustoPrincipal;

    @Id
    @Column(nullable=false, unique=true, name="ID_FUNCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FUNCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CBO", foreignKey=@ForeignKey(name="FK_FUNCAO_CBO"))
    public Cbo getCbo() {
        return this.cbo;
    }

    public void setCbo(Cbo cbo) {
        this.cbo = cbo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FUNCAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} {1}", (Object[])new Object[]{this.getCbo() != null ? this.getCbo().getCodigo() : this.getCbo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="VALOR_REFERENCIA_HORA", precision=15, scale=6)
    public Double getValorReferenciaHora() {
        return this.valorReferenciaHora;
    }

    public void setValorReferenciaHora(Double valorReferenciaHora) {
        this.valorReferenciaHora = valorReferenciaHora;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="CODIGO_CARGO", length=100)
    public String getCodigoCargo() {
        return this.codigoCargo;
    }

    public void setCodigoCargo(String codigoCargo) {
        this.codigoCargo = codigoCargo;
    }

    @Override
    @OneToMany(mappedBy="funcao")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="INFORMAR_CODIGO_ESOCIAL")
    public Short getInformarCodigoEsocial() {
        return this.informarCodigoEsocial;
    }

    public void setInformarCodigoEsocial(Short informarCodigoEsocial) {
        this.informarCodigoEsocial = informarCodigoEsocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO_PRINCIPAL")
    public CentroCusto getCentroCustoPrincipal() {
        return this.centroCustoPrincipal;
    }

    public void setCentroCustoPrincipal(CentroCusto centroCustoPrincipal) {
        this.centroCustoPrincipal = centroCustoPrincipal;
    }
}

