/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.geracaoarquivosbi.ConstEnumGeracaoArquivosBI;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoArquivosBIItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="GERACAO_ARQUIVOS_BI")
public class GeracaoArquivosBI
implements InterfaceVO {
    private Long identificador;
    private Short ativo;
    private Date dataCadastro;
    private Date dataInicial;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Double intervaloConstrucaoHoras;
    private List<GeracaoArquivosBIItem> itensEnvio;
    private Short construirSempreMesmaHora;
    private String descricao;
    private Short formaConstrucao;
    private BusinessIntelligence businessIntelligence;

    public GeracaoArquivosBI() {
        this.formaConstrucao = ConstEnumGeracaoArquivosBI.GERAR_BI_FILTROS.value;
        this.construirSempreMesmaHora = 1;
        this.intervaloConstrucaoHoras = 0.0;
        this.itensEnvio = new LinkedList<GeracaoArquivosBIItem>();
        this.ativo = 0;
    }

    @Id
    @Column(name="ID_GERACAO_ARQUIVOS_BI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_ARQUIVOS_BI")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GER_ARQ_BI_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="INTERVALO_CONSTR_HORAS")
    public Double getIntervaloConstrucaoHoras() {
        return this.intervaloConstrucaoHoras;
    }

    public void setIntervaloConstrucaoHoras(Double intervaloConstrucaoHoras) {
        this.intervaloConstrucaoHoras = intervaloConstrucaoHoras;
    }

    @OneToMany(mappedBy="geracaoArquivosBI", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<GeracaoArquivosBIItem> getItensEnvio() {
        return this.itensEnvio;
    }

    public void setItensEnvio(List<GeracaoArquivosBIItem> itensEnvio) {
        this.itensEnvio = itensEnvio;
    }

    @Column(name="CONSTRUIR_SEMPRE_MESMA_HR")
    public Short getConstruirSempreMesmaHora() {
        return this.construirSempreMesmaHora;
    }

    public void setConstruirSempreMesmaHora(Short construirSempreMesmaHora) {
        this.construirSempreMesmaHora = construirSempreMesmaHora;
    }

    @Column(name="DESCRICAO", length=255)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="FORMA_CONSTRUCAO")
    public Short getFormaConstrucao() {
        return this.formaConstrucao;
    }

    public void setFormaConstrucao(Short formaConstrucao) {
        this.formaConstrucao = formaConstrucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BUSINESS_INTELLIGENCE", foreignKey=@ForeignKey(name="FK_GER_ARQ_BI_BUS_INTELLIGENCE"))
    public BusinessIntelligence getBusinessIntelligence() {
        return this.businessIntelligence;
    }

    public void setBusinessIntelligence(BusinessIntelligence businessIntelligence) {
        this.businessIntelligence = businessIntelligence;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

