/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GERACAO_BOLETO_ENVIO_MASSA")
public class GeracaoBoletoEnvioMassa
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private CarteiraCobranca carteiraCobranca;
    private BorderoTitulos borderoTitulo;
    private List<Rps> listRps = new ArrayList<Rps>();
    private List<NotaFiscalPropria> listNotaPropria = new ArrayList<NotaFiscalPropria>();
    private List<Titulo> listTitulo = new ArrayList<Titulo>();

    @Id
    @Column(nullable=false, name="ID_GERACAO_BOLETO_ENVIO_MASSA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_BOLETO_ENVIO_MASSA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GER_BOLETO_ENVIO_MASSA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_GER_BOLETO_ENVIO_MASSA_CAR_C"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN, CascadeType.MERGE})
    @JoinColumn(name="ID_BORDERO_TITULO", foreignKey=@ForeignKey(name="FK_GER_BOLETO_ENVIO_MASSA_B_TIT"))
    public BorderoTitulos getBorderoTitulo() {
        return this.borderoTitulo;
    }

    public void setBorderoTitulo(BorderoTitulos borderoTitulo) {
        this.borderoTitulo = borderoTitulo;
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=Rps.class)
    @JoinTable(name="RPS_GERACAO_BOLETO", joinColumns={@JoinColumn(name="ID_GERACAO_BOLETO_ENVIO_MASSA")}, inverseJoinColumns={@JoinColumn(name="ID_RPS")})
    public List<Rps> getListRps() {
        return this.listRps;
    }

    public void setListRps(List<Rps> listRps) {
        this.listRps = listRps;
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=NotaFiscalPropria.class)
    @JoinTable(name="NOTA_PROPRIA_GERACAO_BOLETO", joinColumns={@JoinColumn(name="ID_GERACAO_BOLETO_ENVIO_MASSA")}, inverseJoinColumns={@JoinColumn(name="ID_NOTA_PROPRIA")})
    public List<NotaFiscalPropria> getListNotaPropria() {
        return this.listNotaPropria;
    }

    public void setListNotaPropria(List<NotaFiscalPropria> listNotaPropria) {
        this.listNotaPropria = listNotaPropria;
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=Titulo.class)
    @JoinTable(name="TITULO_GERACAO_BOLETO", joinColumns={@JoinColumn(name="ID_GERACAO_BOLETO_ENVIO_MASSA")}, inverseJoinColumns={@JoinColumn(name="ID_TITULO")})
    public List<Titulo> getListTitulo() {
        return this.listTitulo;
    }

    public void setListTitulo(List<Titulo> listTitulo) {
        this.listTitulo = listTitulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

