/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DapiRegimeRecolhimento;
import com.touchcomp.basementor.model.vo.DapiRessarcimentoST;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GERACAO_DAPI")
public class GeracaoDapi
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataInicial;
    private Date dataFinal;
    private Short tipoArquivo = 0;
    private DapiRegimeRecolhimento regimeRecolhimento;
    private Short regimeEspecialFiscalizacao = 0;
    private Date dataPagamento;
    private Short optanteFundese = 0;
    private Short dapiMovimento = 0;
    private Short movimentoCafe = 0;
    private Double saldoIncentivoEsporte = 0.0;
    private Double saldoIncentivoCultura = 0.0;
    private Short outrosCreditosLinha71 = 0;
    private Short outrosDebitosLinha74 = 0;
    private Short termoAceite = 0;
    private Short linhaAjusteCredito = 1;
    private Short linhaAjusteDebito = 1;
    private Short somarIcmsRecolherSubApuracao = 1;
    private List<DapiRessarcimentoST> ressarcimentoST = new ArrayList<DapiRessarcimentoST>();
    private Short linhaOutrosCreditos = 0;
    private Date dataFechamentoBalanco;
    private Short arquivoRetificacao = 0;
    private Short declaracaoMotivoAlteracao = 0;
    private Short declaracaoBaixaEmpresa = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_GERACAO_DAPI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_DAPI")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_DAPI_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="TIPO_ARQUIVO")
    public Short getTipoArquivo() {
        return this.tipoArquivo;
    }

    public void setTipoArquivo(Short tipoArquivo) {
        this.tipoArquivo = tipoArquivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_RECOLHIMENTO", foreignKey=@ForeignKey(name="FK_GERACAO_DAPI_REG_RECOLHIMENT"))
    public DapiRegimeRecolhimento getRegimeRecolhimento() {
        return this.regimeRecolhimento;
    }

    public void setRegimeRecolhimento(DapiRegimeRecolhimento regimeRecolhimento) {
        this.regimeRecolhimento = regimeRecolhimento;
    }

    @Column(name="REGIME_ESPECIAL_FISCALIZACAO")
    public Short getRegimeEspecialFiscalizacao() {
        return this.regimeEspecialFiscalizacao;
    }

    public void setRegimeEspecialFiscalizacao(Short regimeEspecialFiscalizacao) {
        this.regimeEspecialFiscalizacao = regimeEspecialFiscalizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="OPTANTE_FUNDESE")
    public Short getOptanteFundese() {
        return this.optanteFundese;
    }

    public void setOptanteFundese(Short optanteFundese) {
        this.optanteFundese = optanteFundese;
    }

    @Column(name="DAPI_MOVIMENTO")
    public Short getDapiMovimento() {
        return this.dapiMovimento;
    }

    public void setDapiMovimento(Short dapiMovimento) {
        this.dapiMovimento = dapiMovimento;
    }

    @Column(name="MOVIMENTO_CAFE")
    public Short getMovimentoCafe() {
        return this.movimentoCafe;
    }

    public void setMovimentoCafe(Short movimentoCafe) {
        this.movimentoCafe = movimentoCafe;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SALDO_INCENTIVO_ESPORTE", precision=15, scale=4)
    public Double getSaldoIncentivoEsporte() {
        return this.saldoIncentivoEsporte;
    }

    public void setSaldoIncentivoEsporte(Double saldoIncentivoEsporte) {
        this.saldoIncentivoEsporte = saldoIncentivoEsporte;
    }

    @Column(name="SALDO_INCENTIVO_CULTURA", precision=15, scale=4)
    public Double getSaldoIncentivoCultura() {
        return this.saldoIncentivoCultura;
    }

    public void setSaldoIncentivoCultura(Double saldoIncentivoCultura) {
        this.saldoIncentivoCultura = saldoIncentivoCultura;
    }

    @Column(name="OUTROS_CRED_LINHA_71")
    public Short getOutrosCreditosLinha71() {
        return this.outrosCreditosLinha71;
    }

    public void setOutrosCreditosLinha71(Short outrosCreditosLinha71) {
        this.outrosCreditosLinha71 = outrosCreditosLinha71;
    }

    @Column(name="OUTROS_DEB_LINHA_74")
    public Short getOutrosDebitosLinha74() {
        return this.outrosDebitosLinha74;
    }

    public void setOutrosDebitosLinha74(Short outrosDebitosLinha74) {
        this.outrosDebitosLinha74 = outrosDebitosLinha74;
    }

    @Column(name="TERMO_ACEITE")
    public Short getTermoAceite() {
        return this.termoAceite;
    }

    public void setTermoAceite(Short termoAceite) {
        this.termoAceite = termoAceite;
    }

    @Column(name="LINHA_AJUSTE_CREDITO")
    public Short getLinhaAjusteCredito() {
        return this.linhaAjusteCredito;
    }

    public void setLinhaAjusteCredito(Short linhaAjusteCredito) {
        this.linhaAjusteCredito = linhaAjusteCredito;
    }

    @Column(name="LINHA_AJUSTE_DEBITO")
    public Short getLinhaAjusteDebito() {
        return this.linhaAjusteDebito;
    }

    public void setLinhaAjusteDebito(Short linhaAjusteDebito) {
        this.linhaAjusteDebito = linhaAjusteDebito;
    }

    @Column(name="SOMAR_ICMS_RECOLHER_SUB_APUR")
    public Short getSomarIcmsRecolherSubApuracao() {
        return this.somarIcmsRecolherSubApuracao;
    }

    public void setSomarIcmsRecolherSubApuracao(Short somarIcmsRecolherSubApuracao) {
        this.somarIcmsRecolherSubApuracao = somarIcmsRecolherSubApuracao;
    }

    @OneToMany(mappedBy="geracaoDapi", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<DapiRessarcimentoST> getRessarcimentoST() {
        return this.ressarcimentoST;
    }

    public void setRessarcimentoST(List<DapiRessarcimentoST> ressarcimentoST) {
        this.ressarcimentoST = ressarcimentoST;
    }

    @Column(name="LINHA_OUTROS_CREDITOS")
    public Short getLinhaOutrosCreditos() {
        return this.linhaOutrosCreditos;
    }

    public void setLinhaOutrosCreditos(Short linhaOutrosCreditos) {
        this.linhaOutrosCreditos = linhaOutrosCreditos;
    }

    @Column(name="data_fechamento_balanco")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFechamentoBalanco() {
        return this.dataFechamentoBalanco;
    }

    public void setDataFechamentoBalanco(Date dataFechamentoBalanco) {
        this.dataFechamentoBalanco = dataFechamentoBalanco;
    }

    @Column(name="arquivo_retificacao")
    public Short getArquivoRetificacao() {
        return this.arquivoRetificacao;
    }

    public void setArquivoRetificacao(Short arquivoRetificacao) {
        this.arquivoRetificacao = arquivoRetificacao;
    }

    @Column(name="declaracao_motivo_alteracao")
    public Short getDeclaracaoMotivoAlteracao() {
        return this.declaracaoMotivoAlteracao;
    }

    public void setDeclaracaoMotivoAlteracao(Short declaracaoMotivoAlteracao) {
        this.declaracaoMotivoAlteracao = declaracaoMotivoAlteracao;
    }

    @Column(name="declaracao_baixa_empresa")
    public Short getDeclaracaoBaixaEmpresa() {
        return this.declaracaoBaixaEmpresa;
    }

    public void setDeclaracaoBaixaEmpresa(Short declaracaoBaixaEmpresa) {
        this.declaracaoBaixaEmpresa = declaracaoBaixaEmpresa;
    }
}

