/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteTomDiariasCte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GERACAO_DIARIAS_CTE")
public class GeracaoDiariasCte
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataInicial;
    private Date dataFinal;
    private Date dataEmissaoCte;
    private List<TipoOperacao> tipoOperacao = new ArrayList<TipoOperacao>();
    private List<ClienteTomDiariasCte> clienteTomDiariasCte = new ArrayList<ClienteTomDiariasCte>();

    @Id
    @Column(name="ID_GERACAO_DIARIAS_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_DIARIAS_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_DIARIAS_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_CTE")
    public Date getDataEmissaoCte() {
        return this.dataEmissaoCte;
    }

    public void setDataEmissaoCte(Date dataEmissaoCte) {
        this.dataEmissaoCte = dataEmissaoCte;
    }

    @OneToMany
    @JoinTable(name="ger_diarias_cte_tp_ope", joinColumns={@JoinColumn(name="id_geracao_diarias_cte")}, inverseJoinColumns={@JoinColumn(name="id_tipo_operacao")})
    public List<TipoOperacao> getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(List<TipoOperacao> tipoOperacaoCte) {
        this.tipoOperacao = tipoOperacaoCte;
    }

    @OneToMany(mappedBy="geracaoDiariasCte")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ClienteTomDiariasCte> getClienteTomDiariasCte() {
        return this.clienteTomDiariasCte;
    }

    public void setClienteTomDiariasCte(List<ClienteTomDiariasCte> itemGeracaoDiariasCte) {
        this.clienteTomDiariasCte = itemGeracaoDiariasCte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

