/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.TipoOperacaoGeracaoFaturamento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GERACAO_FATURAMENTO")
public class GeracaoFaturamento
implements InterfaceVO {
    private Long identificador;
    private ClassificacaoClientes classificacaoClientes;
    private Date dataInicial;
    private Date dataFinal;
    private Date dataEmissao;
    private Date dataCalcVencimento;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private TipoDoc tipoDoc;
    private String observacao;
    private List<TipoOperacaoGeracaoFaturamento> tipoOperacaoGeracaoFatur = new ArrayList<TipoOperacaoGeracaoFaturamento>();
    private Short gerarBorderoCnab = 0;
    private BorderoTitulos borderoTitulo;
    private CarteiraCobranca carteiraCobranca;

    @Id
    @Column(nullable=false, name="ID_GERACAO_FATURAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_FATURAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CALC_VENCIMENTO")
    public Date getDataCalcVencimento() {
        return this.dataCalcVencimento;
    }

    public void setDataCalcVencimento(Date dataCalcVencimento) {
        this.dataCalcVencimento = dataCalcVencimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_FATURAMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TIPO_DOC", foreignKey=@ForeignKey(name="FK_GERACAO_FATURAMENTO_TP_DOC_F"))
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @OneToMany(mappedBy="geracaoFaturamento", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TipoOperacaoGeracaoFaturamento> getTipoOperacaoGeracaoFatur() {
        return this.tipoOperacaoGeracaoFatur;
    }

    public void setTipoOperacaoGeracaoFatur(List<TipoOperacaoGeracaoFaturamento> tipoOperacaoGeracaoFatur) {
        this.tipoOperacaoGeracaoFatur = tipoOperacaoGeracaoFatur;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="GERAR_BORDERO_CNAB")
    public Short getGerarBorderoCnab() {
        return this.gerarBorderoCnab;
    }

    public void setGerarBorderoCnab(Short gerarBorderoCnab) {
        this.gerarBorderoCnab = gerarBorderoCnab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_BORDERO_TITULO", foreignKey=@ForeignKey(name="FK_GERACAO_FATURAMENTO_BORD_TIT"))
    public BorderoTitulos getBorderoTitulo() {
        return this.borderoTitulo;
    }

    public void setBorderoTitulo(BorderoTitulos borderoTitulo) {
        this.borderoTitulo = borderoTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_GERACAO_FATURAMENTO_CART_COB"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @ManyToOne(targetEntity=ClassificacaoClientes.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTES", nullable=false, foreignKey=@ForeignKey(name="FK_GERACAO_FATUR_CLAS_CLIENTE"))
    public ClassificacaoClientes getClassificacaoClientes() {
        return this.classificacaoClientes;
    }

    public void setClassificacaoClientes(ClassificacaoClientes classificacaoClientes) {
        this.classificacaoClientes = classificacaoClientes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

