/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="geracao_nfe_automatica")
public class GeracaoNfeAutomatizada
implements Serializable {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private UnidadeFatCliente unidadeFatCliente;
    private NaturezaOperacao naturezaOperacao;
    private ModeloFiscal modeloFiscal;
    private Produto produto;
    private Double quantidade = 0.0;
    private CondicoesPagamento condicoesPagamento;
    private NotaFiscalPropria notaPropria;
    private Date dataEmissao;
    private Date horaEmissao;
    private Date dataSaida;
    private Date horaSaida;

    @Id
    @Column(nullable=false, unique=true, name="ID_GERACAO_NFE_AUTOMATICA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_NFE_AUTOMATICA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_cadastro")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="data_atualizacao")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa")
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_unidade_fat_cliente")
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_natureza_operacao")
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_fiscal")
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_produto")
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="REFERENCIA", precision=15, scale=4)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_condicoes_pagamento")
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="id_nota_propria")
    public NotaFiscalPropria getNotaPropria() {
        return this.notaPropria;
    }

    public void setNotaPropria(NotaFiscalPropria notaPropria) {
        this.notaPropria = notaPropria;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="data_emissao")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="hora_emissao")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraEmissao() {
        return this.horaEmissao;
    }

    public void setHoraEmissao(Date horaEmissao) {
        this.horaEmissao = horaEmissao;
    }

    @Column(name="data_saida")
    @Temporal(value=TemporalType.DATE)
    public Date getDataSaida() {
        return this.dataSaida;
    }

    public void setDataSaida(Date dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Column(name="hora_saida")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraSaida() {
        return this.horaSaida;
    }

    public void setHoraSaida(Date horaSaida) {
        this.horaSaida = horaSaida;
    }
}

