/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.OrdemServicoAlteracaoDataProgramacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GERACAO_ORDEM_SERVICO_PLANO")
public class GeracaoOrdemServicoPlanoManutencao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataInicial;
    private Date dataFinal;
    private Short geradoAutomaticamente = 0;
    private SetorExecutante setorExecutante;
    private LocalizacaoAtivo localizacaoAtivo;
    private List<PlanoManutencaoAtivoAtivo> planoManutencaoAtivoAtivo = new ArrayList<PlanoManutencaoAtivoAtivo>();
    private List<OrdemServicoAlteracaoDataProgramacao> ordemServicoAlteracaoDataProgramacao = new ArrayList<OrdemServicoAlteracaoDataProgramacao>();
    private List<CronogramaOrdemServico> cronogramaOrdemServico = new ArrayList<CronogramaOrdemServico>();
    private Pessoa solicitante;
    private Pessoa responsavel;
    private Short gerarOSAtivoNaoExisteOS = 0;

    @Id
    @Column(nullable=false, name="ID_GERACAO_ORDEM_SERVICO_PLANO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_ORDEM_SERVICO_PLANO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GER_ORDEM_SERVICO_PLAN_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="GERADO_AUTOMATICAMENTE")
    public Short getGeradoAutomaticamente() {
        return this.geradoAutomaticamente;
    }

    public void setGeradoAutomaticamente(Short geradoAutomaticamente) {
        this.geradoAutomaticamente = geradoAutomaticamente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SETOR_EXECUTANTE", foreignKey=@ForeignKey(name="FK_GER_ORDEM_SERVICO_PLAN_SET_E"))
    public SetorExecutante getSetorExecutante() {
        return this.setorExecutante;
    }

    public void setSetorExecutante(SetorExecutante setorExecutante) {
        this.setorExecutante = setorExecutante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCALIZACAO_ATIVO", foreignKey=@ForeignKey(name="FK_GER_ORDEM_SERVICO_PLAN_LOC_A"))
    public LocalizacaoAtivo getLocalizacaoAtivo() {
        return this.localizacaoAtivo;
    }

    public void setLocalizacaoAtivo(LocalizacaoAtivo localizacaoAtivo) {
        this.localizacaoAtivo = localizacaoAtivo;
    }

    @OneToMany(mappedBy="geracaoOrdemServicoPlanoManutencao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<PlanoManutencaoAtivoAtivo> getPlanoManutencaoAtivoAtivo() {
        return this.planoManutencaoAtivoAtivo;
    }

    public void setPlanoManutencaoAtivoAtivo(List<PlanoManutencaoAtivoAtivo> planoManutencaoAtivoAtivo) {
        this.planoManutencaoAtivoAtivo = planoManutencaoAtivoAtivo;
    }

    @OneToMany(mappedBy="geracaoOrdemServicoPlanoManutencao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN})
    public List<OrdemServicoAlteracaoDataProgramacao> getOrdemServicoAlteracaoDataProgramacao() {
        return this.ordemServicoAlteracaoDataProgramacao;
    }

    public void setOrdemServicoAlteracaoDataProgramacao(List<OrdemServicoAlteracaoDataProgramacao> ordemServicoAlteracaoDataProgramacao) {
        this.ordemServicoAlteracaoDataProgramacao = ordemServicoAlteracaoDataProgramacao;
    }

    @OneToMany(mappedBy="geracaoOrdemServico", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CronogramaOrdemServico> getCronogramaOrdemServico() {
        return this.cronogramaOrdemServico;
    }

    public void setCronogramaOrdemServico(List<CronogramaOrdemServico> cronogramaOrdemServico) {
        this.cronogramaOrdemServico = cronogramaOrdemServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SOLICITANTE", foreignKey=@ForeignKey(name="FK_GER_ORDEM_SERVICO_PLANO_SOLI"))
    public Pessoa getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Pessoa solicitante) {
        this.solicitante = solicitante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_GER_ORDEM_SERVICO_PLANO_RESP"))
    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    @Column(name="GERAR_OS_ATIVO_NAO_EXISTE_OS", nullable=false)
    public Short getGerarOSAtivoNaoExisteOS() {
        return this.gerarOSAtivoNaoExisteOS;
    }

    public void setGerarOSAtivoNaoExisteOS(Short gerarOSAtivoNaoExisteOS) {
        this.gerarOSAtivoNaoExisteOS = gerarOSAtivoNaoExisteOS;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

