/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemIntegracaoAutonomoFolha;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GERACAO_RECIBO_RPA")
public class GeracaoReciboRpa
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataPagamento;
    private Colaborador colaborador;
    private Double valorRpa = 0.0;
    private Double bcInss = 0.0;
    private Double aliqInss = 0.0;
    private Double vlrInss = 0.0;
    private Double bcIrrf = 0.0;
    private Double aliqIrrf = 0.0;
    private Double vlrIrrf = 0.0;
    private Double vlrIss = 0.0;
    private Double sestSenac = 0.0;
    private Double valorProventos = 0.0;
    private Double valorDescontos = 0.0;
    private Double liquido = 0.0;
    private Date periodoFolha;
    private Short nrDependentes = 0;
    private TipoCalculoEvento tipoCalculoEvento;
    private Short lancado = 0;
    private Short gerarTitulo = 0;
    private Titulo titulo;
    private ItemIntegracaoAutonomoFolha itemFolhaAutonomo;
    private String descricaoServico;
    private Short informarImpostoManual = 0;
    private LoteContabil lote;

    @Id
    @Column(nullable=false, unique=true, name="ID_RECIBO_RPA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECIBO_RPA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_RECIBO_RPA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_GERACAO_RECIBO_RPA_COLABORAD"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(nullable=false, name="VALOR_RPA", precision=15, scale=4)
    public Double getValorRpa() {
        return this.valorRpa;
    }

    public void setValorRpa(Double valorRpa) {
        this.valorRpa = valorRpa;
    }

    @Column(name="BC_INSS", precision=15, scale=4)
    public Double getBcInss() {
        return this.bcInss;
    }

    public void setBcInss(Double bcInss) {
        this.bcInss = bcInss;
    }

    @Column(name="ALIQ_INSS", precision=15, scale=4)
    public Double getAliqInss() {
        return this.aliqInss;
    }

    public void setAliqInss(Double aliqInss) {
        this.aliqInss = aliqInss;
    }

    @Column(name="VLR_INSS", precision=15, scale=4)
    public Double getVlrInss() {
        return this.vlrInss;
    }

    public void setVlrInss(Double vlrInss) {
        this.vlrInss = vlrInss;
    }

    @Column(name="BC_IRRF", precision=15, scale=4)
    public Double getBcIrrf() {
        return this.bcIrrf;
    }

    public void setBcIrrf(Double bcIrrf) {
        this.bcIrrf = bcIrrf = Double.valueOf(bcIrrf == null || bcIrrf < 0.0 ? 0.0 : bcIrrf);
    }

    @Column(name="ALIQUOTA_IRRF", precision=15, scale=4)
    public Double getAliqIrrf() {
        return this.aliqIrrf;
    }

    public void setAliqIrrf(Double aliqIrrf) {
        this.aliqIrrf = aliqIrrf = Double.valueOf(aliqIrrf == null || aliqIrrf < 0.0 ? 0.0 : aliqIrrf);
    }

    @Column(name="VLR_IRRF", precision=15, scale=4)
    public Double getVlrIrrf() {
        return this.vlrIrrf;
    }

    public void setVlrIrrf(Double vlrIrrf) {
        this.vlrIrrf = vlrIrrf;
    }

    @Column(name="VLR_ISS", precision=15, scale=4)
    public Double getVlrIss() {
        return this.vlrIss;
    }

    public void setVlrIss(Double vlrIss) {
        this.vlrIss = vlrIss;
    }

    @Column(nullable=false, name="SEST_SENAC", precision=15, scale=4)
    public Double getSestSenac() {
        return this.sestSenac;
    }

    public void setSestSenac(Double sestSenac) {
        this.sestSenac = sestSenac;
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_PROVENTOS", precision=15, scale=4)
    public Double getValorProventos() {
        return this.valorProventos;
    }

    public void setValorProventos(Double valorProventos) {
        this.valorProventos = valorProventos;
    }

    @Column(name="VALOR_DESCONTOS", precision=15, scale=4)
    public Double getValorDescontos() {
        return this.valorDescontos;
    }

    public void setValorDescontos(Double valorDescontos) {
        this.valorDescontos = valorDescontos;
    }

    @Column(nullable=false, name="VALOR_LIQUIDO", precision=15, scale=4)
    public Double getLiquido() {
        return this.liquido;
    }

    public void setLiquido(Double liquido) {
        this.liquido = liquido;
    }

    @Column(name="PERIODO_FOLHA")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFolha() {
        return this.periodoFolha;
    }

    public void setPeriodoFolha(Date periodoFolha) {
        this.periodoFolha = periodoFolha;
    }

    @Column(name="NR_DEPENDENTES")
    public Short getNrDependentes() {
        return this.nrDependentes;
    }

    public void setNrDependentes(Short nrDependentes) {
        this.nrDependentes = nrDependentes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_GERACAO_RECIBO_RPA_EVENTO"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="LANCADO")
    public Short getLancado() {
        return this.lancado;
    }

    public void setLancado(Short lancado) {
        this.lancado = lancado;
    }

    @Column(name="GERAR_TITULO")
    public Short getGerarTitulo() {
        return this.gerarTitulo;
    }

    public void setGerarTitulo(Short gerarTitulo) {
        this.gerarTitulo = gerarTitulo;
    }

    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_GERACAO_RECIBO_RPA_TITULO"))
    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @OneToOne(mappedBy="reciboRpa")
    public ItemIntegracaoAutonomoFolha getItemFolhaAutonomo() {
        return this.itemFolhaAutonomo;
    }

    public void setItemFolhaAutonomo(ItemIntegracaoAutonomoFolha itemFolhaAutonomo) {
        this.itemFolhaAutonomo = itemFolhaAutonomo;
    }

    @Column(name="DESCRICAO_SERVICO", length=2000)
    public String getDescricaoServico() {
        return this.descricaoServico;
    }

    public void setDescricaoServico(String descricaoServico) {
        this.descricaoServico = descricaoServico;
    }

    @Column(name="INFORMAR_IMPOSTO_MANUAL")
    public Short getInformarImpostoManual() {
        return this.informarImpostoManual;
    }

    public void setInformarImpostoManual(Short informarImpostoManual) {
        this.informarImpostoManual = informarImpostoManual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_lote_Contabil", foreignKey=@ForeignKey(name="fk_lote_contabil_rpa"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public LoteContabil getLote() {
        return this.lote;
    }

    public void setLote(LoteContabil lote) {
        this.lote = lote;
    }
}

