/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AgenciaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GestaoEmprestimoTitulo;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GESTAO_EMPRESTIMO")
public class GestaoEmprestimo
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Double valorEmprestimo = 0.0;
    private Double taxaMensalJuros = 0.0;
    private Integer nrMeses = 0;
    private Integer nrMesesCarencia = 0;
    private Date dataVencimentoPrimeiraParcela;
    private Short metodoEmprestimo = 0;
    private Short tipoIncidenciaJuros = 0;
    private List<GestaoEmprestimoTitulo> listaTitulos = new ArrayList<GestaoEmprestimoTitulo>();
    private String descricao;
    private AgenciaValores agenciaFinanceira;
    private TipoDoc tipoDocumento;
    private Pessoa pessoa;

    @Id
    @Column(name="ID_GESTAO_EMPRESTIMO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GESTAO_EMPRESTIMO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="VALOR_EMPRESTIMO", precision=15, scale=2)
    public Double getValorEmprestimo() {
        return this.valorEmprestimo;
    }

    public void setValorEmprestimo(Double valorEmprestimo) {
        this.valorEmprestimo = valorEmprestimo;
    }

    @Column(nullable=false, name="TAXA_MENSAL_JUROS", precision=15, scale=4)
    public Double getTaxaMensalJuros() {
        return this.taxaMensalJuros;
    }

    public void setTaxaMensalJuros(Double taxaMensalJuros) {
        this.taxaMensalJuros = taxaMensalJuros;
    }

    @Column(name="NR_MESES")
    public Integer getNrMeses() {
        return this.nrMeses;
    }

    public void setNrMeses(Integer nrMeses) {
        this.nrMeses = nrMeses;
    }

    @Column(name="NR_MESES_CARENCIA")
    public Integer getNrMesesCarencia() {
        return this.nrMesesCarencia;
    }

    public void setNrMesesCarencia(Integer nrMesesCarencia) {
        this.nrMesesCarencia = nrMesesCarencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_PRI_PARCELA")
    public Date getDataVencimentoPrimeiraParcela() {
        return this.dataVencimentoPrimeiraParcela;
    }

    public void setDataVencimentoPrimeiraParcela(Date dataVencimentoPrimeiraParcela) {
        this.dataVencimentoPrimeiraParcela = dataVencimentoPrimeiraParcela;
    }

    @Column(name="METODO_EMPRESTIMO")
    public Short getMetodoEmprestimo() {
        return this.metodoEmprestimo;
    }

    public void setMetodoEmprestimo(Short metodoEmprestimo) {
        this.metodoEmprestimo = metodoEmprestimo;
    }

    @Column(name="TIPO_INCIDENCIA_JUROS")
    public Short getTipoIncidenciaJuros() {
        return this.tipoIncidenciaJuros;
    }

    public void setTipoIncidenciaJuros(Short tipoIncidenciaJuros) {
        this.tipoIncidenciaJuros = tipoIncidenciaJuros;
    }

    @OneToMany(mappedBy="gestaoEmprestimo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GestaoEmprestimoTitulo> getListaTitulos() {
        return this.listaTitulos;
    }

    public void setListaTitulos(List<GestaoEmprestimoTitulo> listaTitulos) {
        this.listaTitulos = listaTitulos;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_AGENCIA_VALORES", foreignKey=@ForeignKey(name="FK_GESTAO_EMPRESTIMO_AGEN_VAL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public AgenciaValores getAgenciaFinanceira() {
        return this.agenciaFinanceira;
    }

    public void setAgenciaFinanceira(AgenciaValores agenciaFinanceira) {
        this.agenciaFinanceira = agenciaFinanceira;
    }

    @JoinColumn(name="ID_TIPO_DOC", foreignKey=@ForeignKey(name="FK_GESTAO_EMPRESTIMO_TIPO_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDoc getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(TipoDoc tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_GESTAO_EMPRESTIMO_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

