/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="GRADE_COR", uniqueConstraints={@UniqueConstraint(name="UNQ1_GRADE_COR", columnNames={"CODIGO_BARRAS"}), @UniqueConstraint(name="UNQ2_GRADE_COR", columnNames={"ID_COR", "ID_PRODUTO_GRADE"})})
public class GradeCor
implements InterfaceVO {
    private Long identificador;
    private Cor cor;
    private String codigoBarras;
    private ProdutoGrade produtoGrade;
    private Short gradePrincipal = 0;
    private Integer indice = 0;
    private Timestamp dataAtualizacao;
    private Double qtdGradeRateio = 0.0;
    private Short gradePreferencial = 0;
    private Short ativo = 1;

    @Id
    @Column(name="ID_GRADE_COR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_COR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(unique=true, name="CODIGO_BARRAS", length=25)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="ID_PRODUTO_GRADE", foreignKey=@ForeignKey(name="FK_GRADE_COR_PR_GRADE"))
    public ProdutoGrade getProdutoGrade() {
        return this.produtoGrade;
    }

    public void setProdutoGrade(ProdutoGrade produtoGrade) {
        this.produtoGrade = produtoGrade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COR", foreignKey=@ForeignKey(name="FK_GRADE_COR_COR"))
    public Cor getCor() {
        return this.cor;
    }

    public void setCor(Cor cor) {
        this.cor = cor;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} ({2})", (Object[])new Object[]{this.getIdentificador(), this.getCor(), this.getProdutoGrade() != null ? this.getProdutoGrade().getProduto() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="GRADE_PRINCIPAL")
    public Short getGradePrincipal() {
        return this.gradePrincipal;
    }

    public void setGradePrincipal(Short gr) {
        this.gradePrincipal = gr;
    }

    @Column(name="INDICE")
    public Integer getIndice() {
        return this.indice;
    }

    public void setIndice(Integer indice) {
        this.indice = indice;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="QTD_GRADE_RATEIO", precision=15, scale=6)
    public Double getQtdGradeRateio() {
        return this.qtdGradeRateio;
    }

    public void setQtdGradeRateio(Double qtdGradeRateio) {
        this.qtdGradeRateio = qtdGradeRateio;
    }

    @Column(name="GRADE_PREFERENCIAL")
    public Short getGradePreferencial() {
        return this.gradePreferencial;
    }

    public void setGradePreferencial(Short gradePreferencial) {
        this.gradePreferencial = gradePreferencial;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

