/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.formulacaoprodutos.EnumConstTipoRateioDesmProdConjunta;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AlteracaoFormulacaoProduto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormProdModFichaTec;
import com.touchcomp.basementor.model.vo.GradeFormProdTpSpedProd;
import com.touchcomp.basementor.model.vo.GrupoCaractFormulacao;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemPerdaFormProduto;
import com.touchcomp.basementor.model.vo.ItemSobraFormProduto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRADE_FORMULA_PRODUTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_GRADE_FORMULA_PRODUTO", columnNames={"ID_GRADE_COR", "REVISAO"})})
public class GradeFormulaProduto
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private Short naoGerarSubOS = 0;
    private Timestamp dataAtualizacao;
    private GradeCor gradeCor;
    private List<ItemGradeFormulaProduto> itemGradeFormulaProduto = new ArrayList<ItemGradeFormulaProduto>();
    private List<ItemPerdaFormProduto> itemPerda = new ArrayList<ItemPerdaFormProduto>();
    private List<ItemSobraFormProduto> itemSobra = new ArrayList<ItemSobraFormProduto>();
    private List<GradeFormProdModFichaTec> fichasTecnicas = new ArrayList<GradeFormProdModFichaTec>();
    private Short ativo = 1;
    private GrupoCaractFormulacao grupoCaractFormulacao;
    private Short formulacaoPrincipal = 0;
    private GradeFormulaProduto gradeFormulaProdutoPrincipal;
    private Double quantidadeReferenciaProd = 1.0;
    private String observacao;
    private Short tipoBaixaEstoque = 0;
    private String revisao;
    private Usuario usuario;
    private List<GradeFormProdTpSpedProd> gradeFormProdTpSpedProd;
    private Short gerarRefugoSobraAutomatico = 0;
    private Short utilizarQtdRef = 1;
    private List<AlteracaoFormulacaoProduto> alteracoesFormulacao;
    private Date dataVigInicial;
    private Date dataVigFinal;
    private Short tipoRateioDesmProdConjunta;
    private Short formulacaoSemMaterial;

    public GradeFormulaProduto() {
        this.itemGradeFormulaProduto = new ArrayList<ItemGradeFormulaProduto>();
        this.alteracoesFormulacao = new ArrayList<AlteracaoFormulacaoProduto>();
        this.fichasTecnicas = new ArrayList<GradeFormProdModFichaTec>();
        this.itemPerda = new ArrayList<ItemPerdaFormProduto>();
        this.gradeFormProdTpSpedProd = new ArrayList<GradeFormProdTpSpedProd>();
        this.itemSobra = new ArrayList<ItemSobraFormProduto>();
        this.tipoRateioDesmProdConjunta = EnumConstTipoRateioDesmProdConjunta.PERCENTUAL_INFORMADO.getCodigo();
        this.revisao = String.valueOf(1);
        this.formulacaoSemMaterial = EnumConstantsMentorSimNao.NAO.getValue();
    }

    public GradeFormulaProduto(GradeCor grade) {
        this();
        this.gradeCor = grade;
    }

    @Id
    @Column(name="ID_GRADE_FORMULA_PRODUTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_FORMULA_PRODUTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_FORMULA_PRODUTO_2"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @OneToMany(mappedBy="gradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemGradeFormulaProduto> getItemGradeFormulaProduto() {
        return this.itemGradeFormulaProduto;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setItemGradeFormulaProduto(List<ItemGradeFormulaProduto> itemGradeFormulaProduto) {
        this.itemGradeFormulaProduto = itemGradeFormulaProduto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_FORMULA_PRODUTO_EMPRES"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NAO_GERAR_SUBOS")
    public Short getNaoGerarSubOS() {
        return this.naoGerarSubOS;
    }

    public void setNaoGerarSubOS(Short naoGerarSubOS) {
        this.naoGerarSubOS = naoGerarSubOS;
    }

    @OneToMany(mappedBy="gradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemPerdaFormProduto> getItemPerda() {
        return this.itemPerda;
    }

    public void setItemPerda(List<ItemPerdaFormProduto> itemPerda) {
        this.itemPerda = itemPerda;
    }

    @OneToMany(mappedBy="gradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemSobraFormProduto> getItemSobra() {
        return this.itemSobra;
    }

    public void setItemSobra(List<ItemSobraFormProduto> itemSobra) {
        this.itemSobra = itemSobra;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_CARACT_FORMULACAO", foreignKey=@ForeignKey(name="FK_GRADE_FORMULA_PRODUTO_GR"))
    public GrupoCaractFormulacao getGrupoCaractFormulacao() {
        return this.grupoCaractFormulacao;
    }

    public void setGrupoCaractFormulacao(GrupoCaractFormulacao grupoCaractFormulacao) {
        this.grupoCaractFormulacao = grupoCaractFormulacao;
    }

    @Column(name="FORMULACAO_PRINCIPAL")
    public Short getFormulacaoPrincipal() {
        return this.formulacaoPrincipal;
    }

    public void setFormulacaoPrincipal(Short formulacaoPrincipal) {
        this.formulacaoPrincipal = formulacaoPrincipal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORMULA_PROD_PRINCIPAL", foreignKey=@ForeignKey(name="FK_GRADE_FORM_PROD_FORM_PRINC"))
    public GradeFormulaProduto getGradeFormulaProdutoPrincipal() {
        return this.gradeFormulaProdutoPrincipal;
    }

    public void setGradeFormulaProdutoPrincipal(GradeFormulaProduto gradeFormulaProdutoPrincipal) {
        this.gradeFormulaProdutoPrincipal = gradeFormulaProdutoPrincipal;
    }

    @Column(nullable=false, name="QUANTIDADE_REFERENCIA_PROD", precision=15, scale=6)
    public Double getQuantidadeReferenciaProd() {
        return this.quantidadeReferenciaProd;
    }

    public void setQuantidadeReferenciaProd(Double quantidadeReferenciaProd) {
        this.quantidadeReferenciaProd = quantidadeReferenciaProd;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="TIPO_BAIXA_ESTOQUE")
    public Short getTipoBaixaEstoque() {
        return this.tipoBaixaEstoque;
    }

    public void setTipoBaixaEstoque(Short tipoBaixaEstoque) {
        this.tipoBaixaEstoque = tipoBaixaEstoque;
    }

    @OneToMany(mappedBy="gradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GradeFormProdModFichaTec> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<GradeFormProdModFichaTec> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @Column(name="REVISAO", length=200)
    public String getRevisao() {
        return this.revisao;
    }

    public void setRevisao(String revisao) {
        this.revisao = revisao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_GRADE_FORM_PROD_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OneToMany(targetEntity=GradeFormProdTpSpedProd.class, fetch=FetchType.LAZY, mappedBy="gradeFormulaProduto")
    public List<GradeFormProdTpSpedProd> getGradeFormProdTpSpedProd() {
        return this.gradeFormProdTpSpedProd;
    }

    public void setGradeFormProdTpSpedProd(List<GradeFormProdTpSpedProd> gradeFormProdTpSpedProd) {
        this.gradeFormProdTpSpedProd = gradeFormProdTpSpedProd;
    }

    @Column(name="GERAR_REFUGO_SOBRA_AUT")
    public Short getGerarRefugoSobraAutomatico() {
        return this.gerarRefugoSobraAutomatico;
    }

    public void setGerarRefugoSobraAutomatico(Short gerarRefugoSobraAutomatico) {
        this.gerarRefugoSobraAutomatico = gerarRefugoSobraAutomatico;
    }

    @Column(name="UTILIZAR_QTD_REF")
    public Short getUtilizarQtdRef() {
        return this.utilizarQtdRef;
    }

    public void setUtilizarQtdRef(Short utilizarQtdRef) {
        this.utilizarQtdRef = utilizarQtdRef;
    }

    @OneToMany(mappedBy="gradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.DELETE})
    public List<AlteracaoFormulacaoProduto> getAlteracoesFormulacao() {
        return this.alteracoesFormulacao;
    }

    public void setAlteracoesFormulacao(List<AlteracaoFormulacaoProduto> alteracoesFormulacao) {
        this.alteracoesFormulacao = alteracoesFormulacao;
    }

    @Column(name="DATA_VIG_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVigInicial() {
        return this.dataVigInicial;
    }

    public void setDataVigInicial(Date dataVigInicial) {
        this.dataVigInicial = dataVigInicial;
    }

    @Column(name="DATA_VIG_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVigFinal() {
        return this.dataVigFinal;
    }

    public void setDataVigFinal(Date dataVigFinal) {
        this.dataVigFinal = dataVigFinal;
    }

    @Column(name="TIPO_RATEIO_DESM_PROD_CONJUNTA")
    public Short getTipoRateioDesmProdConjunta() {
        return this.tipoRateioDesmProdConjunta;
    }

    public void setTipoRateioDesmProdConjunta(Short tipoRateioDesmProdConjunta) {
        this.tipoRateioDesmProdConjunta = tipoRateioDesmProdConjunta;
    }

    @Column(name="FORMULACAO_SEM_MATERIAL")
    public Short getFormulacaoSemMaterial() {
        return this.formulacaoSemMaterial;
    }

    public void setFormulacaoSemMaterial(Short formulacaoSemMaterial) {
        this.formulacaoSemMaterial = formulacaoSemMaterial;
    }
}

