/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendas;
import com.touchcomp.basementor.model.vo.ItemSimulacaoCotVendas;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRADE_ITEM_COT_VENDAS")
public class GradeItemCotVendas
implements InterfaceVO {
    private Long identificador;
    private GradeCor gradeCor;
    private Double quantidade;
    private ItemCotacaoVendas itemCotacaoVendas;
    private ItemSimulacaoCotVendas itemSimulacaoCotVendas;

    public GradeItemCotVendas() {
        this.setQuantidade(0.0);
        this.quantidade = 0.0;
    }

    public GradeItemCotVendas(GradeCor grade) {
        this.gradeCor = grade;
        this.setQuantidade(0.0);
    }

    @Id
    @Column(name="ID_GRADE_ITEM_COT_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_COT_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COT_VENDAS_1"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_COTACAO_VENDAS", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COT_VENDAS_2"))
    public ItemCotacaoVendas getItemCotacaoVendas() {
        return this.itemCotacaoVendas;
    }

    public void setItemCotacaoVendas(ItemCotacaoVendas itemCotacaoVendas) {
        this.itemCotacaoVendas = itemCotacaoVendas;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        Object ret1 = "";
        Object ret2 = "";
        int cont = 0;
        if (this.getItemCotacaoVendas() != null && this.getItemCotacaoVendas().getCotacaoVendas() != null) {
            ret1 = " Cotacao: " + this.getItemCotacaoVendas().getCotacaoVendas().getIdentificador();
            ++cont;
        }
        if (this.getItemCotacaoVendas() != null && this.getItemCotacaoVendas().getCotacaoVendas() != null && this.getItemCotacaoVendas().getCotacaoVendas().getUnidadeFatCliente() != null) {
            ret2 = " Cliente: " + this.getItemCotacaoVendas().getCotacaoVendas().getUnidadeFatCliente().getCliente().getPessoa().getNome();
            ++cont;
        }
        if (!"".equals(ret1) && ((String)ret2).equals("")) {
            return ToolBaseMethodsVO.toString((String)"{0} {1}", (Object[])new Object[]{this.getGradeCor() != null ? this.getGradeCor().getCor() : this.getGradeCor(), ret1});
        }
        if (((String)ret1).equals("") && !"".equals(ret2)) {
            return ToolBaseMethodsVO.toString((String)"{0} {1}", (Object[])new Object[]{this.getGradeCor() != null ? this.getGradeCor().getCor() : this.getGradeCor(), ret2});
        }
        if (!"".equals(ret1) && !"".equals(ret2)) {
            return ToolBaseMethodsVO.toString((String)"{0} {1} {2}", (Object[])new Object[]{this.getGradeCor() != null ? this.getGradeCor().getCor() : this.getGradeCor(), ret1, ret2});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getGradeCor() != null ? this.getGradeCor().getCor() : this.getGradeCor()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="gradeItemCotVendas")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public ItemSimulacaoCotVendas getItemSimulacaoCotVendas() {
        return this.itemSimulacaoCotVendas;
    }

    public void setItemSimulacaoCotVendas(ItemSimulacaoCotVendas itemSimulacaoCotVendas) {
        this.itemSimulacaoCotVendas = itemSimulacaoCotVendas;
    }
}

