/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRADE_ITEM_IMP_SALDO")
public class GradeItemImpSaldo
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private Double valorUnitario;
    private Double valorUltCustoUnit;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private ItemImplantaSaldo itemImplantaSaldo;
    private Date dataMovimentacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;

    public GradeItemImpSaldo() {
        this.quantidade = 0.0;
        this.valorUnitario = 0.0;
        this.valorUltCustoUnit = 0.0;
    }

    public GradeItemImpSaldo(GradeCor grade) {
        this.gradeCor = grade;
        this.quantidade = 0.0;
        this.valorUnitario = 0.0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_GRADE_ITEM_IMP_SALDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_IMP_SALDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_IMP_SALDO_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradecor) {
        this.gradeCor = gradecor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_IMP_SALDO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_IMP_SALDO_IT_SAL"))
    public ItemImplantaSaldo getItemImplantaSaldo() {
        return this.itemImplantaSaldo;
    }

    public void setItemImplantaSaldo(ItemImplantaSaldo itemImplantaSaldo) {
        this.itemImplantaSaldo = itemImplantaSaldo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE})
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_IMP_SALDO_LOTE"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_MOVIMENTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Column(name="VALOR_ULT_CUSTO_UNIT", precision=15, scale=6)
    public Double getValorUltCustoUnit() {
        return this.valorUltCustoUnit;
    }

    public void setValorUltCustoUnit(Double valorUltCustoUnit) {
        this.valorUltCustoUnit = valorUltCustoUnit;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_IMP_SALDO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_IMP_SALDO_CEN"), updatable=false)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }
}

