/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedidoLoteFab;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPlanProdEncProdGrPedido;
import com.touchcomp.basementor.model.vo.ItemPlanProdLinProdGrPedido;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRADE_ITEM_PEDIDO")
public class GradeItemPedido
implements InterfaceVO {
    private Long identificador;
    private ItemPedido itemPedido;
    private GradeCor gradeCor;
    private Double quantidade = 0.0;
    private Short reservarEstoque = 1;
    private List<ItemPlanProdLinProdGrPedido> itensPlanProdLinProd = new ArrayList<ItemPlanProdLinProdGrPedido>();
    private List<ItemPlanProdEncProdGrPedido> itensPlanProdEncProd = new ArrayList<ItemPlanProdEncProdGrPedido>();
    private List<GradeItemPedidoLoteFab> lotesFabricacao = new ArrayList<GradeItemPedidoLoteFab>();
    private Timestamp dataAtualizacao;
    private Short movimentacaoFisica = 0;
    private Date dataMovimentacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;
    private LoteFabricacao loteFabricacao;

    public GradeItemPedido() {
    }

    public GradeItemPedido(GradeCor grade) {
        this();
        this.gradeCor = grade;
        this.movimentacaoFisica = 0;
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ITEM_PEDIDO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_PEDIDO_IT_PED"))
    public ItemPedido getItemPedido() {
        return this.itemPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_PEDIDO_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=12, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setItemPedido(ItemPedido itemPedido) {
        this.itemPedido = itemPedido;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="RESERVAR_ESTOQUE")
    public Short getReservarEstoque() {
        return this.reservarEstoque;
    }

    public void setReservarEstoque(Short reservarEstoque) {
        this.reservarEstoque = reservarEstoque;
    }

    @OneToMany(mappedBy="gradeItemPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GradeItemPedidoLoteFab> getLotesFabricacao() {
        return this.lotesFabricacao;
    }

    public void setLotesFabricacao(List<GradeItemPedidoLoteFab> lotesFabricacao) {
        this.lotesFabricacao = lotesFabricacao;
    }

    @OneToMany(mappedBy="gradeItemPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemPlanProdLinProdGrPedido> getItensPlanProdLinProd() {
        return this.itensPlanProdLinProd;
    }

    public void setItensPlanProdLinProd(List<ItemPlanProdLinProdGrPedido> itensPlanProdLinProd) {
        this.itensPlanProdLinProd = itensPlanProdLinProd;
    }

    @OneToMany(mappedBy="gradeItemPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemPlanProdEncProdGrPedido> getItensPlanProdEncProd() {
        return this.itensPlanProdEncProd;
    }

    public void setItensPlanProdEncProd(List<ItemPlanProdEncProdGrPedido> itensPlanProdEncProd) {
        this.itensPlanProdEncProd = itensPlanProdEncProd;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    @Column(name="DATA_MOVIMENTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_PEDIDO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_PEDIDO_LOTE"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_PEDIDO_CEN_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }
}

