/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="GRADE_ITEM_REQUISICAO")
public class GradeItemRequisicao
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private ItemRequisicao itemRequisicao;
    private Date dataMovimentacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;

    public GradeItemRequisicao() {
        this.setQuantidade(0.0);
        this.quantidade = 0.0;
    }

    public GradeItemRequisicao(GradeCor grade) {
        this.gradeCor = grade;
        this.setQuantidade(0.0);
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_REQUISICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_REQUISICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_REQUISICAO_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(nullable=false, name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_REQUISICAO_LOTE"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ITEM_REQUISICAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_REQUISICAO_IT_REQ"))
    public ItemRequisicao getItemRequisicao() {
        return this.itemRequisicao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public void setItemRequisicao(ItemRequisicao itemRequisicao) {
        this.itemRequisicao = itemRequisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTACAO")
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_REQUISICAO_CEN"), updatable=false)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_REQUISICAO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

