/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="GR_ITEM_TRANSF_CENTRO_EST")
public class GradeItemTransfCentroEstoque
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private ItemTransfCentroEstoque itemTransfCentroEst;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private Date dataTransferencia;
    private Empresa empresa;
    private CentroEstoque origem;
    private CentroEstoque destino;

    public GradeItemTransfCentroEstoque() {
        this.quantidade = 0.0;
        this.dataTransferencia = new Date();
    }

    public GradeItemTransfCentroEstoque(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_GR_ITEM_TRANSF_CENTRO_EST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GR_ITEM_TRANSF_CENTRO_EST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_TRANSF_CENTRO_EST", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_IC"))
    public ItemTransfCentroEstoque getItemTransfCentroEst() {
        return this.itemTransfCentroEst;
    }

    public void setItemTransfCentroEst(ItemTransfCentroEstoque itemTransfCentroEst) {
        this.itemTransfCentroEst = itemTransfCentroEst;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_LO"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Column(name="DATA_TRANSFERENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataTransferencia() {
        return this.dataTransferencia;
    }

    public void setDataTransferencia(Date dataTransferencia) {
        this.dataTransferencia = dataTransferencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_EM"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_EST_DESTINO", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_ED"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getDestino() {
        return this.destino;
    }

    public void setDestino(CentroEstoque destino) {
        this.destino = destino;
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_EST_ORIGEM", foreignKey=@ForeignKey(name="FK_GR_ITEM_TRANSF_CENTRO_EST_EO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getOrigem() {
        return this.origem;
    }

    public void setOrigem(CentroEstoque origem) {
        this.origem = origem;
    }
}

