/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueFabricante;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGC;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRUPO_ANALISE_ESTOQUE")
public class GrupoAnaliseEstoque
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String descricao;
    private Date dataBaseAnalise;
    private Short numeroInteiro = 0;
    private Integer leadTimeBase = 0;
    private Integer diasCobertura = 0;
    private Integer diasAnalise = 0;
    private Double fatorSeguranca = 0.0;
    private List<Empresa> empresas = new ArrayList<Empresa>();
    private List<SubEspecie> subespecies = new ArrayList<SubEspecie>();
    private List<GrupoAnaliseEstoqueFabricante> fabricante;
    private List<TipoItemSped> tiposItemSped = new ArrayList<TipoItemSped>();
    private List<GrupoAnaliseEstoqueGC> gradesAnalise = new ArrayList<GrupoAnaliseEstoqueGC>();
    private Short tipoPrazoLeadTime = 0;
    private Timestamp dataAtualizacao;
    private Date dataAnalise;
    private ClassificacaoAnaliseEstoque classificacaoAnaliseEstoque;

    public GrupoAnaliseEstoque() {
        this.fabricante = new ArrayList<GrupoAnaliseEstoqueFabricante>();
    }

    @Id
    @Column(name="ID_GRUPO_ANALISE_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_ANALISE_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DESCRICAO", length=150)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_BASE_ANALISE")
    public Date getDataBaseAnalise() {
        return this.dataBaseAnalise;
    }

    public void setDataBaseAnalise(Date dataBaseAnalise) {
        this.dataBaseAnalise = dataBaseAnalise;
    }

    @Column(name="NUMERO_INTEIRO")
    public Short getNumeroInteiro() {
        return this.numeroInteiro;
    }

    public void setNumeroInteiro(Short numeroInteiro) {
        this.numeroInteiro = numeroInteiro;
    }

    @Column(name="LEAD_TIME_BASE")
    public Integer getLeadTimeBase() {
        return this.leadTimeBase;
    }

    public void setLeadTimeBase(Integer leadTimeBase) {
        this.leadTimeBase = leadTimeBase;
    }

    @Column(name="DIAS_COBERTURA")
    public Integer getDiasCobertura() {
        return this.diasCobertura;
    }

    public void setDiasCobertura(Integer diasCobertura) {
        this.diasCobertura = diasCobertura;
    }

    @Column(nullable=false, name="FATOR_SEGURANCA", precision=15, scale=4)
    public Double getFatorSeguranca() {
        return this.fatorSeguranca;
    }

    public void setFatorSeguranca(Double fatorSeguranca) {
        this.fatorSeguranca = fatorSeguranca;
    }

    @OneToMany
    @JoinTable(name="grupo_anal_estoque_emp", inverseJoinColumns={@JoinColumn(name="id_empresa")}, joinColumns={@JoinColumn(name="id_grupo_analise_estoque")})
    public List<Empresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<Empresa> empresas) {
        this.empresas = empresas;
    }

    @OneToMany
    @JoinTable(name="grupo_anal_estoque_sub", inverseJoinColumns={@JoinColumn(name="id_subespecie")}, joinColumns={@JoinColumn(name="id_grupo_analise_estoque")})
    public List<SubEspecie> getSubespecies() {
        return this.subespecies;
    }

    public void setSubespecies(List<SubEspecie> subespecies) {
        this.subespecies = subespecies;
    }

    @OneToMany
    @JoinTable(name="grupo_anal_estoque_tp_item", inverseJoinColumns={@JoinColumn(name="id_tipo_item_sped")}, joinColumns={@JoinColumn(name="id_grupo_analise_estoque")})
    public List<TipoItemSped> getTiposItemSped() {
        return this.tiposItemSped;
    }

    public void setTiposItemSped(List<TipoItemSped> tiposItemSped) {
        this.tiposItemSped = tiposItemSped;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DIAS_ANALISE")
    public Integer getDiasAnalise() {
        return this.diasAnalise;
    }

    public void setDiasAnalise(Integer diasAnalise) {
        this.diasAnalise = diasAnalise;
    }

    @OneToMany(mappedBy="grupoAnaliseEstoque")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GrupoAnaliseEstoqueGC> getGradesAnalise() {
        return this.gradesAnalise;
    }

    public void setGradesAnalise(List<GrupoAnaliseEstoqueGC> gradesAnalise) {
        this.gradesAnalise = gradesAnalise;
    }

    @Column(name="TIPO_PRAZO_LEAD_TIME")
    public Short getTipoPrazoLeadTime() {
        return this.tipoPrazoLeadTime;
    }

    public void setTipoPrazoLeadTime(Short tipoPrazoLeadTime) {
        this.tipoPrazoLeadTime = tipoPrazoLeadTime;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ANALISE")
    public Date getDataAnalise() {
        return this.dataAnalise;
    }

    public void setDataAnalise(Date dataAnalise) {
        this.dataAnalise = dataAnalise;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFI_ANALISE_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRUPO_ANALISE_ESTOQUE_CLASSI"))
    public ClassificacaoAnaliseEstoque getClassificacaoAnaliseEstoque() {
        return this.classificacaoAnaliseEstoque;
    }

    public void setClassificacaoAnaliseEstoque(ClassificacaoAnaliseEstoque classificacaoAnaliseEstoque) {
        this.classificacaoAnaliseEstoque = classificacaoAnaliseEstoque;
    }

    @OneToMany(mappedBy="grupoAnaliseEstoque", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GrupoAnaliseEstoqueFabricante> getFabricante() {
        return this.fabricante;
    }

    public void setFabricante(List<GrupoAnaliseEstoqueFabricante> fabricante) {
        this.fabricante = fabricante;
    }
}

